import json
import os
from PIL import Image
from tqdm import tqdm


output_list = []
cnt = 0
for ln in tqdm(open("androidcontrol_test_parsed_is_clickable_ui.json", encoding='utf-8')):
    ep = json.loads(ln)
    for i in range(len(ep["actions"])):
        img_filename = "./androidcontrol_test/" + ep["screenshots"][i].replace('[', '').replace(']', '').split('/')[-1]
        if not os.path.exists(img_filename):
            print(img_filename)
            continue
        original_image = Image.open(img_filename)

        if not original_image.mode == "RGB":
            original_image = original_image.convert("RGB")
        original_size = original_image.size

        output_list.append(
            {
                "episode_id": ep["episode_id"],
                "img_filename": img_filename,
                "width": original_size[0],
                "height": original_size[1],
                "total_goal": ep["goal"],
                "step_instruction": ep["step_instructions"][i],
                "action": json.loads(ep["actions"][i]),
                "ui_text": ep["ui_texts"][i]
            }
        )

print(len(output_list))
with open("android_control_test_simple.json", "w", encoding='utf-8') as f:
    json.dump(output_list, f, indent=4, ensure_ascii=False)

