import json
from tqdm import tqdm
import copy

fout = open("androidcontrol_test_parsed_is_clickable_ui.jsonl", 'w', encoding="utf-8")
for ln in tqdm(open("androidcontrol_test_parsed.json", encoding='utf-8')):
    item = json.loads(ln)
    new_accessibility_trees = []
    new_ui_texts = []
    for accessibility_tree in item["accessibility_trees"]:
        new_accessibility_tree = []
        new_ui_text = ""
        cnt = 0
        for i in accessibility_tree:
            if i["element_properties"]["is_clickable"] is True and i["element_properties"]["is_visible_to_user"] is True:
                new_accessibility_tree.append(i)
                if i['textual_attributes']['content_description'] != "":
                    new_ui_text += f"Box ID {cnt}: {i['textual_attributes']['content_description']}\n"
                elif i['textual_attributes']["text"] != "":
                    new_ui_text += f"Box ID {cnt}: {i['textual_attributes']['text']}\n"
                else:
                    new_ui_text += f"Box ID {cnt}: \n"
                cnt += 1
        new_accessibility_trees.append(copy.deepcopy(new_accessibility_tree))
        new_ui_texts.append(copy.deepcopy(new_ui_text))

    item["accessibility_trees"] = copy.deepcopy(new_accessibility_trees)
    item["ui_texts"] = copy.deepcopy(new_ui_texts)
    fout.write(json.dumps(item, ensure_ascii=False) + '\n') 

