from PIL import Image, ImageDraw, ImageFont
import json
from tqdm import tqdm

font_size = 40
font = ImageFont.load_default(font_size)

def draw_bounding_box(image_path, boxes, output_path):
    image = Image.open(image_path)
    draw = ImageDraw.Draw(image)


    for idx, box in enumerate(boxes):
        x1, y1, x2, y2 = box


        try:
            draw.rectangle(box, outline="red", width=3)
            draw.text((x1, (y1+y2)/2 - font_size), str(idx), font=font, fill="green")
        except:
            continue


    image.save(output_path)


for ln in tqdm(open("androidcontrol_test_parsed.json", encoding='utf-8')):
    item = json.loads(ln)
    for image_path, accessibility_tree in zip(item["screenshots"], item["accessibility_trees"]):

        boxes = [
            [
                i["location_and_size"]["bounds_in_screen"]["left"],
                i["location_and_size"]["bounds_in_screen"]["top"],
                i["location_and_size"]["bounds_in_screen"]["right"],
                i["location_and_size"]["bounds_in_screen"]["bottom"],
            ]
            for i in accessibility_tree if i["element_properties"]["is_clickable"] is True and i["element_properties"]["is_visible_to_user"] is True
        ]

        output_path = f"androidcontrol_test_is_clickable/" + image_path.split("/")[-1]

        draw_bounding_box(image_path, boxes, output_path)
    
