# Description: Constants used in the project.

# Number of test samples
NUMBER_TEST_SAMPLES = 1000

# Regularization that is used instead of zero regularization to avoid numerical issues
ZERO_REGULARIZATION = 1e-8

NUMBER_OF_MODELS_FOR_VARIANCE = 20000  # NOTE: For big experiments we used 4000

# We use the color palette from Okabe and Ito (reordered)
COLORS = [
    "#56B4E9",  # blue
    "#CC79A7",  # red-purple
    "#009E73",  # green
    "#D55E00",  # red-orange
    "#E69F00",  # orange
]

# More visual cues for lines
LINE_STYLES = ["-", "--", "-."]

SIZE_DEFAULT = 12
SIZE_LARGE = 16

FIG_SIZE = (6.4, 4)

NORMALIZATION_METHOD = "none"

FITTING_PROCEDURE = "lstsq"  # Set to "cholesky" or "lstsq"
