#!/bin/bash
set -e

DATA_DIR="~/data/inat2018"
mkdir -p "$DATA_DIR"

# 方法 1：用 TensorFlow Datasets，下载 +导出图片到本地
python - <<'PY'
from torchvision.datasets import INaturalist
from torchvision import transforms

dataset = INaturalist(
    root="~/data/inat2018",
    version="2018",
    target_type="full",   # 或者 "super" 等
    transform=transforms.ToTensor(),
    download=True
)
PY

# 方法 2：如果有直接下载链接或 Kaggle zip，使用 wget / kaggle cli
# 示例 Kaggle 下载指令（你需要先配置 kaggle api token）
# kaggle competitions download -c inaturalist-2018 -p $DATA_DIR

echo "Done downloading iNat2018 classification data"
