#!/bin/bash

## 一次性清空所有 CUDA 进程 (⚠️会杀死当前机器上所有用GPU的进程，小心！)
#echo "Killing all CUDA processes..."
#fuser -k /dev/nvidia* || true

# 激活环境命令
CONDA_INIT="source ~/miniconda3/etc/profile.d/conda.sh && conda activate torch"

# Baseline
echo "Running Baseline..."
bash -c "$CONDA_INIT && \
python finetune_vit.py --master_port 12341 --data_dir /usr/homes/cxz760/data --dataset cifar100 --epochs 100 --batch_size 256 --img_size 224 --lr 1e-2 --resume /home/cxz760/MAE-Lite/outputs/mae_lite/mae_tiny_distill_400e/last_epoch_ckpt.pth.tar
" \
> save/finetune_cifar100_baseline_vanilla_vit.log 2>&1

# Parallel d6 b2 lambda=0->1
echo "Running Parallel d6 b2 lambda=0..."
bash -c "$CONDA_INIT && \
python finetune_vit_para.py --master_port 12342 --data_dir /usr/homes/cxz760/data --dataset cifar100 --epochs 100 --batch_size 256 --img_size 224 --lr 1e-3 --resume /home/cxz760/MAE-Lite/outputs/mae_lite/mae_tiny_distill_400e_d6_b2/last_epoch_ckpt.pth.tar --lambda_policy linear" \
> save/finetune_cifar100_parallel_d6b2_linear_lambda.log 2>&1

# Parallel d6 b2 lambda=0
echo "Running Parallel d6 b2 lambda=0->1..."
bash -c "$CONDA_INIT && \
python finetune_vit_para.py --master_port 12343 --data_dir /usr/homes/cxz760/data --dataset cifar100 --epochs 100 --batch_size 256 --img_size 224 --lr 1e-3 --resume /home/cxz760/MAE-Lite/outputs/mae_lite/mae_tiny_distill_400e_d6_b2/last_epoch_ckpt.pth.tar --lambda_off 0" \
> save/finetune_cifar100_baseline_multibranch_d6b2_lambda0.log 2>&1

# Parallel d6 b2 lambda=1
echo "Running Parallel d6 b2 lambda=1..."
bash -c "$CONDA_INIT && \
python finetune_vit_para.py --master_port 12344 --data_dir /usr/homes/cxz760/data --dataset cifar100 --epochs 100 --batch_size 256 --img_size 224 --lr 1e-3 --resume /home/cxz760/MAE-Lite/outputs/mae_lite/mae_tiny_distill_400e_d6_b2_linear_lambda/last_epoch_ckpt.pth.tar --lambda_off 1" \
> save/finetune_cifar100_parallel_d6b2_lambda1.log 2>&1

echo "All experiments finished!"
