# Self-Weighted Guidance (SWG)

Self-Weighted Guidance (SWG) paper repository.

Self-Weighted Guidance (SWG) is a novel guidance method in which both the data and its associated weights are modeled by the same diffusion model. This unified modeling enables a self-guided sampling process, where the diffusion model effectively guides itself during generation. 

This repository is built using JAX/Flax, WandB for logging and Hydra for managing hyperparameters.

## Installation

We recommend using [Miniconda] to manage dependencies.

### 1. Clone the Repository

```bash
git clone 
cd SWG-JAX
```

### 2. Create and Activate a Conda Environment

```bash
conda env create -f environment.yml
conda activate swg_jax
conda develop .
```

## Usability

To modify the main hyperparameters for experiments, edit the following file:

```bash
configs/D4RL/config.yaml
```

## Training

Replace dataset_name and your_seed, and execute

```bash
python scripts/train.py datasets={dataset_name} method=swg seed={your_seed}
```

## Evaluating

Change the evaluation parameters in scripts/evaluate.py and run

```bash
python scripts/evaluate.py
```
