# Code  for CoRL 2024 submission: Verification of Neural Control Barrier Functions with Symbolic Derivative Bounds Propagation

Our code and pre-trained models will be released and available to the public once our work is accepted. This version is not very clean but can fully reproduce all of our experimental results. Here is a brief instruction to run the code. 

## Preparation
The code is based on [Julia](https://julialang.org/) and is tested with Julia v1.9.4. Check [here](https://julialang.org/downloads/oldreleases/) to install Julia environment. Install `ModelVerification.jl` from [this repo](https://github.com/intelligent-control-lab/ModelVerification.jl). Install `RobotZoo.jl` from [this repo](https://github.com/RoboticExplorationLab/RobotZoo.jl).

## Data Collection
To collect data for each robot dynamics, see Jupyter file `collect_data.ipynb` for details.

## Model training 
For the model training under Point Robot, see Jupyter file `train_naive_point.ipynb` for regular training and `train_adv_point.ipynb` for adversarial training. For the model training under Dubins Car, see Jupyter file `train_naive_car.ipynb` for regular training and `train_adv_car.ipynb` for adversarial training. For the model training under Planar Quadrotor, see Jupyter file `train_naive_planar_quad.ipynb` for regular training and `train_adv_planar_quad.ipynb` for adversarial training.


## Verification of neural CBFs
For the verificaiton under Dubins Car, see Jupyter file `verify_car.ipynb` and replace the corresponding path with `naive` or `adv` for different pre-trained models. Also, $\alpha$ and number of grids per dimension can also specified for ablation study.



