import json

# 读取原始JSON文件
with open('/mnt/haoling/data/RL_29k_tasks_with_solutions_greater_than_5.json', 'r', encoding='utf-8') as f:
    data = json.load(f)  # 加载JSON数据（应为列表格式）

# 打印第一条数据的key（如果列表非空）
if data:
    first_item = data[0]
    print("数据包含的key:", list(first_item.keys()))
else:
    print("数据列表为空")

# 提取并保存task字段到JSONL文件
with open('/mnt/haoling/data/RL_29k_tasks_with_solutions_greater_than_5_task.jsonl', 'w', encoding='utf-8') as outfile:
    for item in data:
        # 检查是否存在task字段
        if "task" in item:
            # 创建仅包含task字段的新对象
            task_data = {"task": item["task"]}
            # 写入JSONL文件（每行一个JSON对象）
            json.dump(task_data, outfile, ensure_ascii=False)
            outfile.write('\n')  # 添加换行符分隔