import base64
import os
from utils.call_gpt import call_gpt

def encode_image(image_path):
    with open(image_path, "rb") as f:
        return base64.b64encode(f.read()).decode("utf-8")

def build_multimodal_prompt(text, image_paths=None):
    content = []
    if text:
        content.append({"type": "text", "text": text})
    if image_paths:
        for path in image_paths:
            if not os.path.exists(path):
                print(f"图片不存在: {path}")
                continue
            ext = os.path.splitext(path)[1].lower()
            mime = {
                ".jpg": "image/jpeg",
                ".jpeg": "image/jpeg",
                ".png": "image/png",
                ".webp": "image/webp"
            }.get(ext, "image/jpeg")
            base64_img = encode_image(path)
            content.append({
                "type": "image_url",
                "image_url": {
                    "url": f"data:{mime};base64,{base64_img}"
                }
            })
    return [{"role": "user", "content": content}]

def call_gpt_multimodal(text, image_paths=None, system_prompt="", model="gpt-4o", **kwargs):
    """
    适配你的call_gpt，支持图文输入
    """
    prompt = build_multimodal_prompt(text, image_paths)
    if system_prompt:
        prompt = [{"role": "system", "content": system_prompt}] + prompt
    return call_gpt(prompt, system_prompt="", model=model, **kwargs)

# 示例用法
if __name__ == "__main__":
    text = "请描述图片内容"
    images = ["/home/superbench/haoling/Desktop/visualization/analysis_efficiency/efficiency.png"]
    system_prompt = "你是一个图片分析专家"
    result = call_gpt_multimodal(text, images, system_prompt)
    print(result)