import openai
import concurrent.futures
import time
# from sglang.utils import wait_for_server, print_highlight, terminate_process
# 配置客户端
host = "0.0.0.0"
port = 30000  # 请将这个端口设置为你的实际端口号
client = openai.Client(base_url=f"http://{host}:{port}/v1", api_key="None")

question = "Given a certain number, how many multiples of three could you obtain with its digits?\n\nSuposse that you have the number 362. The numbers that can be generated from it are:\n```\n362 ----> 3, 6, 2, 36, 63, 62, 26, 32, 23, 236, 263, 326, 362, 623, 632 \n```\nBut only:\n\n```3, 6, 36, 63``` are multiple of three.\n\nWe need a function that can receive a number ann may output in the following order:\n\n- the amount of multiples\n\n- the maximum multiple\n\nLet's see a case the number has a the digit 0 and repeated digits:\n```\n6063 ----> 0, 3, 6, 30, 36, 60, 63, 66, 306, 360, 366, 603, 606, 630, 636, 660, 663, 3066, 3606, 3660, 6036, 6063, 6306, 6360, 6603, 6630\n```\nIn this case the multiples of three will be all except 0\n\n```\n6063 ----> 3, 6, 30, 36, 60, 63, 66, 306, 360, 366, 603, 606, 630, 636, 660, 663, 3066, 3606, 3660, 6036, 6063, 6306, 6360, 6603, 6630\n```\n\nThe cases above for the function:\n```python\nfind_mult_3(362) == [4, 63]\n\nfind_mult_3(6063) == [25, 6630]\n```\nIn Javascript ```findMult_3()```.\nThe function will receive only positive integers (num > 0), and you don't have to worry for validating the entries.\n\nFeatures of the random tests:\n```\nNumber of test = 100\n1000 ≤ num ≤ 100000000\n```\nEnjoy it!!"


response_code_block = """```python
from itertools import permutations

def find_mult_3(num):
    num_str = str(num)
    unique_numbers = set()

    # Generate all unique permutations of all lengths
    for length in range(1, len(num_str) + 1):
        for perm in permutations(num_str, length):
            number = int(''.join(perm))
            unique_numbers.add(number)

    # Filter the numbers that are multiples of 3 and not zero
    multiples_of_3 = [number for number in unique_numbers if number != 0 and number % 3 == 0]

    # Find the maximum multiple of 3
    max_multiple = max(multiples_of_3) if multiples_of_3 else 0

    # Return the count of multiples and the maximum multiple
    return [len(multiples_of_3), max_multiple]

# Example usage:
print(find_mult_3(362))   # Output: [4, 63]
print(find_mult_3(6063))  # Output: [25, 6630]
```"""


prompt = f"""I have an algorithm competition problem and the corresponding python solution, but I have verified that the solution is wrong, and I would like you to point out on which line the error occurs.

### Problem
{question}

### Python Solution
{response_code_block}

Please note that your formatting must adhere to the following rules.
1. Select the only line of code that you think is most likely to cause an error in your code.
2. You need to give the contents of the wrong line of code, enclosed in a python code block.
3. You don't need to give anything to understand, analyze, or correct the error.

### Example Output
```python
Error Code Line
```
"""



# 定义发送请求的函数
def send_request():
    try:
        response = client.chat.completions.create(
            model="Qwen/Qwen2.5-Coder-7B-Instruct",
            messages=[
                {"role": "system", "content": "A conversation between User and Assistant. The user asks a question, and the Assistant solves it by proving a reasoning process along with a python program. The assistant first thinks about the reasoning process in the mind and then provides the user with the answer (python program only). The reasoning process and answer are enclosed within <think> </think> and <answer> </answer> tags, respectively, i.e., <think> reasoning process here </think> <answer> answer here </answer>."},
                {"role": "user", "content": question},
            ],
            temperature=0.7,
            max_tokens=8192,
        )
        print(f"Response: {response}")
        if response.choices and len(response.choices) > 0:
            answer = response.choices[0].message.content
            print(answer)
    except Exception as e:
        print(f"Request failed: {e}")

# 并发请求数量
num_requests = 1

# 使用 ThreadPoolExecutor 实现多线程
def main():
    start_time = time.time()
    with concurrent.futures.ThreadPoolExecutor(max_workers=1) as executor:
        futures = [executor.submit(send_request) for _ in range(num_requests)]
        concurrent.futures.wait(futures)
    end_time = time.time()
    
    print(f"Sent {num_requests} requests in {end_time - start_time} seconds")

if __name__ == "__main__":
    main()
