# Copyright 2024 PRIME team and/or its affiliates
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from .utils import check_correctness as apps_check_correctness
import json
import re
import traceback
import numpy as np
import time
    
    



def compute_score(completion, test_cases, continuous=False):
    # try to get code solution from completion. if the completion is pure code, this will not take effect.
    solution = completion.split('```python')[-1].split('```')[0]
    start_time = time.time()
    
    try:
        try:
            if not isinstance(test_cases, dict):
                test_cases = json.loads(test_cases)
        except Exception as e:
            print(f"Error:{e}")

        # Complete check on all in-out pairs first. If there is no failure, per-sample test can be skipped.
        try:
            res, metadata = apps_check_correctness(in_outs=test_cases, generation=solution, timeout=5, debug=False)
            metadata = dict(enumerate(metadata))[0]
            success = all(map(lambda x: x == True, res))
            if success:
                return success, metadata
        except Exception as e:
            pass

        test_cases_list = []
        # inputs = test_cases["inputs"]
        # outputs = test_cases["outputs"]
        
        ########### TODO： need to be optimized
        if isinstance(test_cases, str):
            test_cases = json.loads(test_cases)
        if isinstance(test_cases, dict):

            inputs = test_cases.get("input")
            if inputs is None or len(inputs) == 0:  # Explicitly check if input_case is None or empty
                inputs = test_cases.get("inputs")

            outputs = test_cases.get("output")
            if outputs is None or len(outputs) == 0:  # Explicitly check if input_case is None or empty
                outputs = test_cases.get("outputs")

            if isinstance(inputs, (list, np.ndarray)): 
                inputs = list(inputs)  
            else:
                inputs = [inputs]  

            if isinstance(outputs, (list, np.ndarray)):  
                outputs = list(outputs)  
            else:
                outputs = [outputs]  #
        else:
            raise TypeError("test_cases is neither a valid dictionary nor a JSON string.")
        ###########
        
        
        
        
        
        for i in range(len(inputs)):
            test_cases_list.append({"inputs": [inputs[i]], "outputs": [outputs[i]]})

        if continuous:
            # per sample test: if continuous score is needed, test first 10 samples regardless of failures
            # do not test all samples cuz some problems have enormous test cases
            metadata_list = []
            res_list = []
            for test_case_id, test_case in enumerate(test_cases_list):
                res, metadata = apps_check_correctness(in_outs=test_case, generation=solution, timeout=5, debug=False)
                try:
                    metadata = dict(enumerate(metadata))[0]  # metadata can be empty occasionally
                except Exception as e:
                    metadata = {}
                metadata["test_case"] = {}
                metadata["test_case"]["input"] = str(test_case["inputs"][0])
                metadata["test_case"]["output"] = str(test_case["outputs"][0])
                metadata["test_case"]["res"] = str(res)
                metadata_list.append(metadata)
                res_list.extend(res)

                if test_case_id >= 9:
                    break
            res_count = len(res_list) if len(res_list) > 0 else 1
            success = sum(map(lambda x: x == True, res_list)) / res_count
    except Exception as e:
        traceback.print_exc(10)
        success = False
        metadata_list = None

    end_time = time.time()
    print(f"Finished computing score. Time taken: {end_time - start_time} seconds.")
    
    return success, metadata_list
