import os
import torch
import torch.nn as nn
import torch.nn.functional as F
from torch.autograd import Variable
import numpy as np

def to_var(x, volatile=False):
    if torch.cuda.is_available():
        x = x.cuda()
    return Variable(x, volatile=volatile)

def mkdir(directory):
    if not os.path.exists(directory):
        os.makedirs(directory)


class Shuffling(nn.Module):
    def __init__(self,):
        super(Shuffling, self).__init__()

    def forward(self, z):
        n, d = z.shape
        z_shuffle = z.copy_()
        # shuffling
        for i in range(d):
            z_shuffle[:, i] = z[torch.randperm(n), i]
        return z_shuffle
