import architectures.resnet50
import architectures.googlenet
import architectures.bninception
import architectures.densenet121
import architectures.senet50
import architectures.multifeature_resnet50
import architectures.multifeature_densenet121

def select(arch, opt):
    if 'multifeature_resnet50' in arch:
        return multifeature_resnet50.Network(opt)
    if 'multifeature_densenet121' in arch:
        return multifeature_densenet121.Network(opt)
    if 'resnet50' in arch:
        return resnet50.Network(opt)
    if 'googlenet' in arch:
        return googlenet.Network(opt)
    if 'bninception' in arch:
        return bninception.Network(opt)
    if 'densenet121' in arch:
        return densenet121.Network(opt)
    if 'senet50' in arch:
        return senet50.Network(opt)
