import datasets.cub200
import datasets.cars196
import datasets.celeba
import datasets.lfw

def select(dataset, opt, data_path):
    if 'cub200' in dataset:
        return cub200.Give(opt, data_path)

    if 'cars196' in dataset:
        return cars196.Give(opt, data_path)

    if 'celeba' in dataset:
        return celeba.Give(opt, data_path)
    
    if 'LFW' in dataset:
        return lfw.Give(opt, data_path)

    raise NotImplementedError('A dataset for {} is currently not implemented.\n\
                               Currently available are : cub200, cars196, celeba, LFW and MIMIC-CXR!'.format(dataset))
