from sklearn.gaussian_process.kernels import RBF
from scipy.spatial.distance import pdist
import numpy as np
import torch

class Metric():
    def __init__(self, length_scale, **kwargs):
        self.length_scale = length_scale
        self.requires = ['features', 'target_labels']
        self.name = 'rbf@{}'.format(length_scale)
    
    def __call__(self, features, target_labels, indices=None):
        try:
            self.kernel = RBF(length_scale = self.length_scale)
            unif = self.kernel(features.cpu(), features.cpu())
        except MemoryError:
            unif = np.exp(-1*pdist(features.cpu())/(2*(self.length_scale**2)))
        if indices is not None:
            raise NotImplementedError
        return unif.mean()

