using PyPlot
using DelimitedFiles

function myPlot(filename, numEpochs, numEpochsBatch, rate)
    A = readdlm(filename, '\t', Float64, '\n')

    s = 1; t = rate * numEpochs + 1
    SQSB = A[s: t, :]
    s = t + 1; t = s + numEpochsBatch - 1
    RRR  = A[s: t, :]
    s = t + 1
    FW   = A[s: end, :]

    foldername = "figures"
    if ~isdir(foldername)
        mkdir(foldername)
    end

    foldername = foldername * "/" * filename 
    if ~isdir(foldername)
        mkdir(foldername)
    end

    close("all")

    figure(1)
    plot(SQSB[:,1], SQSB[:,2])
    hold
    plot(RRR[:,1], RRR[:,2])
    plot(FW[:,1], FW[:,2])
    grid("on")
    legend(["SQSB", "RρR", "FW"])
    xlabel("Number of Epochs")
    ylabel("Fidelity")
    savefig(foldername * "/" * filename * "-epoch-fidelity.png")

    figure(2)
    approxOpt = minimum(vcat(SQSB[:,4], RRR[:,4], FW[:,4]))
    semilogy(SQSB[:,1], SQSB[:,4] .- approxOpt)
    hold
    semilogy(RRR[:,1], RRR[:,4] .- approxOpt)
    semilogy(FW[:,1], FW[:,4] .- approxOpt)
    grid("on")
    ylim([1e-5, 1e-1])
    legend(["SQSB", "RρR", "FW"])
    xlabel("Number of Epochs")
    ylabel("Approximate optimization error")
    savefig(foldername * "/" * filename * "-epoch-error.png")

    figure(3)
    semilogx(SQSB[:,3], SQSB[:,2])
    hold
    semilogx(RRR[:,3], RRR[:,2])
    semilogx(FW[:,3], FW[:,2])
    grid("on")
    legend(["SQSB", "RρR", "FW"])
    xlabel("Elapsed time (sec)")
    ylabel("Fidelity")
    savefig(foldername * "/" * filename * "-time-fidelity.png")

    figure(4)
    approxOpt = minimum(vcat(SQSB[:,4], RRR[:,4], FW[:,4]))
    loglog(SQSB[:,3], SQSB[:,4] .- approxOpt)
    hold
    loglog(RRR[:,3], RRR[:,4] .- approxOpt)
    loglog(FW[:,3], FW[:,4] .- approxOpt)
    grid("on")
    ylim([1e-5, 1e-1])
    legend(["SQSB", "RρR", "FW"])
    xlabel("Elapsed time (sec)")
    ylabel("Approximate optimization error")
    savefig(foldername * "/" * filename * "-time-error.png")
end