<!-- Improved compatibility of back to top link: See: https://github.com/othneildrew/Best-README-Template/pull/73 -->
<a name="readme-top"></a>
<!--
*** Thanks for checking out the Best-README-Template. If you have a suggestion
*** that would make this better, please fork the repo and create a pull request
*** or simply open an issue with the tag "enhancement".
*** Don't forget to give the project a star!
*** Thanks again! Now go create something AMAZING! :D
-->



<!-- PROJECT LOGO -->
<br />
<div align="center">


  <h1 align="center">Neural Phylogeny</h1>

  <p align="center">
    Unveil the fine-tuning behavior and identify the fine-tuning direction among neural networks.
    <!-- <br />
    <a href="https://github.com/othneildrew/Best-README-Template"><strong>Explore the docs »</strong></a>
    <br />
    <br />
    <a href="https://github.com/othneildrew/Best-README-Template">View Demo</a>
    ·
    <a href="https://github.com/othneildrew/Best-README-Template/issues">Report Bug</a>
    ·
    <a href="https://github.com/othneildrew/Best-README-Template/issues">Request Feature</a> -->
  <!-- </p>
  <p align="center">
    <img src="asset/HeadImages.png" alt="Image">
  </p> -->

</div>



<!-- TABLE OF CONTENTS -->
<details>
  <summary style="font-size: 20px;">Table of Contents</summary>
  <ol>
    <li><a href="#environment-setup">Environment Setup</a></li>
    <li><a href="#data-preparation">Data Preparation</a></li>
    <li><a href="#pre-trained-models">Pre-trained Models</a></li>
    <li><a href="#learning-free-clustering-method">Learning-Free Clustering Method</a></li>
    <li><a href="#detector">Detector</a></li>
  </ol>
</details>

## Environment Setup
Our code is implemented using python 3.8,10, pytorch 2.0.0 and cuda 12.0. All the relied packages are listed in the `environment.yaml` file. Run the following code, which will creates and activates a virual environment named *phylogeny*.

```bash
conda env create -f environment.yaml
conda activate phylogeny
```
<p align="right">(<a href="#readme-top">back to top</a>)</p>

## Data Preparation
The data used in the work to train the neural network models are all standard **torchvision.datasets** and are saved in the `data` folder by default.

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## Pre-trained Models
The pre-trained models are stored by default in `Models` folder. The `.json` files in the `config` folder summarize the parent and child models, which will be used in the experiments.

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## Learning-Free Clustering Method

The following command is to run the learning-free methods. For each clustering algorithm, there are specific parameters, which should be set before running the code. Please check the parser registration section in `phylogenyclustering.py `, where we list all the parameters for each algorithm.

```sh
cd src

python phylogenyclustering.py \
        --pmodel the-parent-model-set \ # e.g., RESNET18_ImageNet
        --cmodel the-child-model \ # e.g., set RESNET18_FMNIST
        --method the-clustering-algorithm \ # e.g. DBSCAN
        --other-parameters value-of-other-parameters # see the phylogenyclustering.py 
```

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## Detector

The following command is to train the detector the logged reuslt will also included the performance evaluation.


```sh
cd src

python phylogenydetector.py \
        --pmodel the-parent-model-set \ # e.g., RESNET18_ImageNet
        --cmodel the-child-model \ # e.g., set RESNET18_FMNIST
        --model default \ # model architecture
        --num_encoder_layers 5 \
        --num_layers 1 \ # number of transformer layers
        --embed_dim 16 \
        --batch-size 16 \
        --lr 0.01 \
        --epochs 100
```

<p align="right">(<a href="#readme-top">back to top</a>)</p>