#!/bin/bash

export CUDA_VISIBLE_DEVICES=0
params=("badnet" "sleeper" "synbkd")

declare -A model_config_prefixes=(
    ["deepseek_distill_llama3_8b"]="deepseek_distill_llama3_8b"
    ["llama2_7b"]="llama2_7b_chat"
    ["llama2_13b"]="llama2_13b_chat"
    ["llama3_8b"]="llama3_8b_chat"
    ["mistral_7b"]="mistral_7b"
)

task_type="jailbreak"
# task_type="refusal"
for param in "${params[@]}"; do
    for model in "${!model_config_prefixes[@]}"; do
        config_prefix="${model_config_prefixes[$model]}"
        config_file="configs/${task_type}/${config_prefix}/${model}_${task_type}_${param}_lora.yaml"
        echo "Running with trigger: $param , task_type: $task_type and model: $model using config file: $config_file"
        torchrun --nnodes=1 --node_rank=0 --nproc_per_node=1 --master_addr=127.0.0.1 --master_port=1121 backdoor_train.py ${config_file}
        echo "Finished."
        echo "----------------------------------------"
    done
done



