# Submission Number 19875
The repository is based on
PRC: https://github.com/XuandongZhao/PRC-Watermark/tree/main
Black Box Attacks: https://github.com/and-mill/semantic-forgery

## Install
First, create a python 3.12 envirnoment with you favourite tool.
We installed torch 2.8 and CUDA 12.8 via pip. Please adjust in case of different hardware.
Finally, please pip install -r requirements.txt

## general workings of the repository

This repository works as follows: You can generate sample images and then verify watermarks with different access patterns and noise levels.
To ensure repoducability, we generated 10000 nonces and messanges as well as 1000 keys upfront. They can be found in the respective files in the utils/wm directory. They are hardwired into the experiment, but a generation file is included.

The reference implementation of Gaussian Shading is GSreference. GSppReference contains the reference implementation of GS++. GSchroma is for perceptual hashes, GSoptimised contain the other optimisations. They can be called with --rand_check and --db_lookup. With every watermark there are some additional parameters: For GS, an --fpr 1e-6 is necessary, otherwise a wrong default is used. For GS++, please provide --t 7 for the configuration of the PRC used.

### generate images

First, some files need to be created upfront. A sample call is

final_experiment.py --experiment batch_create --verbose

For perceptual hashes (GSchroma), nonceDB_chroma.py needs to be run to set up a chroma database with DINO features. By default, it takes the images of GSreference.

For db_lookup, a sqlite3 database needs to be build. That is done by nonceDB_sql.py.

### run experiments

Next, experiments can be run. We offer top (first images), misses (generates unwatermarked images and tries to verify the watermark) and random (takes ever --step_size image up to --amount).

For the experiments with noise, we provide final_experiment_noisy.py. It takes multiple watermarking schemes at once (as a list) and can do multiple noises at once. However, please make sure to only use it on comparable images such as GSoptimised and GSreference.Please make sure to always provide a list of --distortion and --distortion_value of the same length and repeat the type, so e.g --distortion jpeg_ratio jpeg_ratio --distortion value 80 20. The available distortions can be found in image_utils.py. It always does the top experiment.

You can observe sample calls in test.sh.

