#!/bin/bash

# Define the list of values for --wm_type
WMs=("GSreference" "GSoptimised" "PRC" "GSchroma" "GSppReference")

# Define other default arguments
GSARGS="--fpr 1e-6"
DISTORTION="--distortion gaussian_std_fixed gaussian_std_fixed gaussian_std_fixed gaussian_std_fixed --distortion_value 0.05 0.5 1 2"
DISTORTIONBLUR="--distortion gaussian_blur_r gaussian_blur_r gaussian_blur_r gaussian_blur_r --distortion_value 4 6 8 12"

#generation
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --experiment batch_create --verbose --amount 10 --wm_type GSreference $GSARGS
# CUDA_VISIBLE_DEVICES=0 python3 final_experiment.py --experiment batch_create --verbose --amount 10 --wm_type PRC
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --experiment batch_create --verbose --amount 10 --wm_type GSppReference $GSARGS --t 7

#top 2
TOPTWO="--batch_size 1 --amount 2 --experiment top --verbose --filepath_img ./images/"
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --wm_type GSreference $GSARGS $TOPTWO
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --wm_type GSoptimised $GSARGS $TOPTWO --rand_check
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --wm_type PRC $TOPTWO
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --wm_type GSppReference $TOPTWO $GSARGS --t 7

#misses 2
# MISSESTWO="--batch_size 1 --amount 2 --experiment misses --verbose --filepath_img ./images/"
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --wm_type GSreference $GSARGS $MISSESTWO
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --wm_type GSoptimised $GSARGS $MISSESTWO --rand_check
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --wm_type PRC $MISSESTWO
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --wm_type GSppReference $MISSESTWO $GSARGS --t 7

#random 2
RANDOMTWO="--batch_size 1 --amount 4 --step_size 2 --experiment random --verbose --filepath_img ./images/"
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --wm_type GSreference $GSARGS $RANDOMTWO
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --wm_type GSoptimised $GSARGS $RANDOMTWO --rand_check
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --wm_type PRC $RANDOMTWO
# CUDA_VISIBLE_DEVICES=3 python3 final_experiment.py --wm_type GSppReference $RANDOMTWO $GSARGS --t 7 --exact_inversion

#noisy 
NOISYTWO="--amount 2 --experiment random --verbose --filepath_img ./images/ --filepath ./data/"
NOISE="--distortion jpeg_ratio gaussian_blur_r gaussian_std_fixed --distortion_value 90 2 0.05"
CUDA_VISIBLE_DEVICES=3 python3 final_experiment_noisy.py --wm_type GSreference GSoptimised1 PRC $GSARGS $NOISYTWO $NOISE
