import random

import torch
import numpy as np

def set_random_seed(seed=0):
    """
    Set random seed for reproducibility
    """
    torch.manual_seed(seed + 0)
    torch.cuda.manual_seed(seed + 1)
    torch.cuda.manual_seed_all(seed + 2)
    np.random.seed(seed + 3)
    torch.cuda.manual_seed_all(seed + 4)
    random.seed(seed + 5)

def log_to_file(filepath,log_list):
    log_string = ",".join(map(str,log_list))
    with open(filepath+".csv", 'a') as file:  # Open the file in append mode
        file.write(log_string + '\n')  # Add a newline for each log entry

def log_to_out(verbose,log_list):
    if verbose:
        print(log_list)