
# Experiments of NRQ

## NRQ expreiment
```bash
cd ./NRQ

# Equilibrium state experimental curves of risk, loss, au and weight norm
cd ./equilibrium
python3 train_and_plot.py

# Experimental Curves of stationary density and tail probability with different au
cd ./equilibrium
python3 f_eq.py
python3 f_tail_xi.py

# "Escape" behavior, and preserved dynamics with adjusted hyperparameters
cd ./non_equilibrium
python3 train_and_plot.py
```

## CIFAR experiment

```bash
cd ./CIFAR

# Standard experiment with different lr and WD factor
python3 train.py --learing_rate 0.5 --weight_decay 1e-3

# Rescale strategy
python3 train.py --exp_type rescale

# enlarge the initial value of weight norm while preserving the training curves
python3 train.py --exp_type init_equiv --enlarge_factor 10
```

## Image experiment
```bash
cd ./ImageNet

# set train/eval dataset dir
# 8 GPUs are required to train

# enlarge the initial value of weight norm while preserving the training curves
python3 -m torch.distributed.launch --nproc_per_node=8 train.py --train_dataset_dir train_dataset_dir --gpu_nums 8 --enlarge_factor 10

# eval, 1 gpu is required
python3 test.py --iter 225000 --eval_dataset_dir eval_dataset_dir
```
