import numpy as np
import matplotlib.pyplot as plt

C = 1e2


def f_den(x, k, p):

    r = 2 * k / C
    t = np.exp(C * x)
    t = t / np.max(t)
    y = np.power(t, r) / np.power(x, 1/2) * np.power(1-x, (p-3)/2)
    n = len(x)
    N = 0.0
    N = np.longdouble(N)
    for i in range(n-1):
        N += y[i] * (x[i+1] - x[i])
    return N, y / N


def f_mean(x, k, p):

    r = 2 * k / C
    t = np.exp(C * x)
    t = t / np.max(t)
    y = np.power(t, r) * np.power(x, 1 / 2) * np.power(1 - x, (p - 3) / 2)
    n = len(x)
    M = 0.0
    M = np.longdouble(M)
    for i in range(n - 1):
        M += y[i] * (x[i + 1] - x[i])
    return M, y / M


def main():

    p = 100
    lr = 0.1
    wd = 1e-1
    s2 = 1
    k = np.sqrt(p-1) / np.sqrt(2 * lr * wd * s2) / 2

    x1 = np.linspace(0.01, 1, 2000, endpoint=True)
    x2 = np.logspace(-12, -2, 100, endpoint=False)
    x = np.concatenate((x2, x1))
    x = np.longdouble(x)
    #print(x)

    #au_list = np.sqrt(2 * [2.5e-2, 1e-2, 7.5e-3, 5e-3, 2.5e-3, 1e-3, 7.5e-4, 5e-4, 2.5e-4])
    au_list = np.arange(1.5e-2, 1.6e-1, 2e-2)
    L = len(au_list)
    for i in range(len(au_list)):
        d = au_list[i]
        k = np.sqrt(p-1) / 2 / d / s2
        N, y = f_den(x, k, p)
        plt.plot(x, y, linewidth=1, color=[i/L, 0, 1-i/L], label='au='+str(round(d, 4)))

        M, y = f_mean(x, k, p)
        plt.axvline(M / N, linewidth=0.6, linestyle='--', color=[i/L, 0, 1-i/L])

    plt.ylim(0, 40)
    plt.xlim(0, 1)
    plt.xlabel("f")
    plt.legend()
    #plt.axhline(0)
    plt.savefig('./fig/density.png', dpi=800, bbox_inch='tight')
    plt.show()


if __name__ == '__main__':
    main()
