expr_prefix="image-sketch"  # image-sketch, video-audio
config_names=${config_names}" pretrained_res50_sktssllv_sktdistill_tublv_clipm_lv_split1_adam1e-3"
seeds=97
gpu_ids=(0 1)
gpu_num=2
max_num=2
curr_num=0

datadir="/yours/datasets"  
for seed in $seeds
do
    for config_name in $config_names    
    do
        date_info=`date +%Y_%m_%d_%H_%M`
        date_info=${date_info}_${seed}
        echo ${date_info}
        workdir=./exprs/$expr_prefix/$config_name/$date_info/
        if [[ ! -d $workdir ]]; then
            mkdir $workdir
        fi
        cp ./exprs/$expr_prefix/$config_name/config.yaml $workdir
        
        gpu_id=${gpu_ids[$(($curr_num % $gpu_num))]}
        FINAL_FILE=./exprs/$expr_prefix/$config_name/$date_info/chckpoints/target_lv/final2.pth
        if [[ ! -f "$FINAL_FILE" ]]
        then
            echo $seed
            echo $config_name
            python3 train.py --config ./exprs/$expr_prefix/$config_name/config.yaml \
                                --work-dir $workdir \
                                --data-dir $datadir \
                                --gpu-ids $gpu_id \
                                --seed $seed \
                                --wandb &
        
            curr_num=$(($curr_num + 1))
        fi
        if [[ ${curr_num} -ge ${max_num} ]]
        then
            sleep 7202220s
            curr_num=0
        fi
    done
done

echo "Finished."
