import numpy as np
import torch
import wandb

def wandb_mat_image(mat):
    """Create a wandb image for logging.
    Args:
        mat[torch.tensor, C_1 x C_2]: 0-1
    """
    mat = mat.detach().cpu().numpy()
    h, w = mat.shape
    mat = np.tile(mat.reshape(h, w, 1), 3)
    image = wandb.Image((mat * 255).astype(np.int))
    return image

def mat_message(mat):
    mat = mat.detach().cpu().numpy()
    rows = [" ".join([str(mat[i][j]) for j in range(len(mat[i]))]) for i in range(len(mat))]
    return "\n".join(rows)

