# Copyright (c) OpenMMLab. All rights reserved.
# from .eval_hooks import DistEvalHook, EvalHook
from .eval_metrics import (accuracy, fuzziness, calculate_confusion_matrix, f1_score, precision,
                           precision_recall_f1, recall, support)
from .mean_ap import average_precision, mAP
from .multilabel_eval_metrics import average_performance
from .confmat import ConfusionMatrix

class AverageMeter(object):
    """Computes and stores the average and current value"""
    def __init__(self):
        self.reset()

    def reset(self):
        self.val = 0
        self.avg = 0
        self.sum = 0
        self.count = 0

    def update(self, val, n=1):
        self.val = val
        self.sum += val * n
        self.count += n
        self.avg = self.sum / self.count

__all__ = [
    'AverageMeter',
    'accuracy', 'precision', 'recall', 'f1_score', 'support', 'average_precision', 'mAP',
    'average_performance', 'calculate_confusion_matrix', 'precision_recall_f1',
    # 'EvalHook', 'DistEvalHook'
]
