""" This module contains the Edge class, which represents a road segment between two locations. 
author: Anonymous
"""

import os
import sys
import inspect

currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
sys.path.insert(0, parentdir)

from scheduling.location import Location
from utils.edge_space import Edge

class Edge:
    def __init__(self, start: Location, end: Location):
        self.start = min(start, end)
        self.end = max(start, end)
        self.length = start.distance(end)
        
        self.buffer = {}
        
    def reserve_edge(self, agent_id, start_time, speed):
        end_time = start_time + self.length / speed
        self.buffer[agent_id] = (start_time, end_time)
        
    def is_reserved(self, agent_id, start_time, speed):
        for other_agent_id, (other_start_time, other_end_time) in self.buffer.items():
            if other_agent_id == agent_id:
                continue
            if (start_time < other_end_time and start_time > other_start_time) or (start_time < other_end_time and start_time > other_start_time):
                return True
        return False
        
    def reset(self):
        self.buffer = {}
        
    def __eq__(self, other):
        return self.start == other.start and self.end == other.end
    
    def __hash__(self):
        return hash((self.start, self.end))
    
    def __repr__(self):
        return f"({self.start} -> {self.end})"
    
    def __str__(self):
        return f"({self.start} -> {self.end})"
    