"""
"""
import os
import sys
import inspect

currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
sys.path.insert(0, parentdir) 

from scheduling.location import Location
from path_planning.edge import Edge

class Path:
    def __init__(self, waypoints) -> None:
        self.waypoints = waypoints
        
        edges = [ Edge(start, end) for start, end in zip(self.waypoints[:-1], self.waypoints[1:]) ]
        self.distance = sum([edge.length for edge in edges])
        
    def get_waypoints(self):
        return self.waypoints
    
    def intersection(self, other):
        """Returns the intersection of two paths"""
        # get the intersection in sorted order
        edges = [ Edge(start, end) for start, end in zip(self.waypoints[:-1], self.waypoints[1:]) ]
        other_edges = [ Edge(start, end) for start, end in zip(other.waypoints[:-1], other.waypoints[1:]) ]
        return [edge for edge in edges if edge in other_edges]
    
    def __eq__(self, other):
        return set(self.waypoints) == set(other.waypoints)
    
    def __hash__(self):
        return hash(tuple(self.waypoints))
    
    def __repr__(self):
        """Returns a string representation of the path
        "Prints: (0, 0) -> (1, 1) -> (2, 2) -> (3, 3)"
        """
        return " -> ".join([str(waypoint) for waypoint in self.waypoints])
    
    def __str__(self):
        """Returns a string representation of the path
        "Prints: (0, 0) -> (1, 1) -> (2, 2) -> (3, 3)"
        """
        return " -> ".join([str(waypoint) for waypoint in self.waypoints])    
        
    def __len__(self):
        return len(self.waypoints) - 1