"""
author: Anonymous
"""
import os
import sys
import inspect

currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
sys.path.insert(0, parentdir) 

import copy
import numpy as np

from scheduling.location import Location
from scheduling.task import Task

from gym import spaces
from gym import Env

class Agent(Env):
    def __init__(self, id, x, y, speed, max_speed=10, map_size=(100, 100), num_tasks=10) -> None:
        super().__init__()
        self.id = id
        self.max_speed = max_speed
        self.map_size = map_size
        self.num_tasks = num_tasks
        
        self.location = Location(x, y)
        self.speed = speed
        
        self.current_makespan = 0
        self.assigned_tasks = []
        # Observation: [
            # x, # range between 0.0 and 1.0
            # y, # range between 0.0 and 1.0
            # speed, # range between 0.0 and 1.0
            # num_assigned_tasks # range between 0.0 and 1.0
        # ]
        self.observation_space = spaces.Tuple(
            (
                # spaces.Box(low=0, high=1, shape=(1,), dtype=np.float32),
                # spaces.Box(low=0, high=1, shape=(1,), dtype=np.float32),
                spaces.Box(low=0, high=1, shape=(1,), dtype=np.float32),
                spaces.Box(low=0, high=1, shape=(1,), dtype=np.float32),
                spaces.Box(low=0, high=100, shape=(1,), dtype=np.float32)
            )
        )
        
    def reset(self):
        self.assigned_tasks = []
        self.current_makespan = 0
        # return self.get_observation()
        
    def get_observation(self, deadline):
        # location = self.get_location()
        # return an np.array of features
        feature = [
            # location[0] / self.map_size[0], 
            # location[1] / self.map_size[1], 
            self.speed / self.max_speed, 
            self.current_makespan / deadline,
            len(self.assigned_tasks)
        ]
        return np.array(feature)
    
    def deep_copy(self, source):
        self.id = source.id
        self.max_speed = source.max_speed
        self.map_size = source.map_size
        self.num_tasks = source.num_tasks
        self.location = source.location
        self.speed = source.speed
        self.current_makespan = source.current_makespan
        
        self.assigned_tasks = []
        for task in source.assigned_tasks:
            t = Task(task.id, task.location.x, task.location.y, task.start_time, task.end_time)
            t.deep_copy(task)
            self.assigned_tasks.append(t)
             
    @staticmethod
    def get_feature_size():
        # A Singleton Function to return the size of the feature space for a single Agent
        return 3
    
    @staticmethod
    def agent_speed_index(self):
        return 0
    
    @staticmethod
    def agent_current_makespan_index():
        return 1
    
    def step(self, action: Task, expected_completion_time):
        # action is a task assignment
        self.assigned_tasks.append(action)
        self.current_makespan = expected_completion_time
        
        
    def get_location(self):
        if len(self.assigned_tasks) == 0:
            return self.location.get_location()
        else:
            return self.assigned_tasks[-1].location.get_location()
    
    def __dict__(self):
        return {
            'id': self.id,
            'x': self.location.x,
            'y': self.location.y,
            'speed': self.speed
        }
    
    @staticmethod
    def get_feature_space():
        return [
            "Speed",
            "Current Makespan",
            "Number of Assigned Tasks"
        ]