"""
author: Anonymous
"""

import os
import sys
import inspect


currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
sys.path.insert(0, parentdir) 

import numpy as np
from dataclasses import dataclass
import tyro

from scheduling.environment import SchedulingEnvironment
from utils.utils import set_seed
    

@dataclass
class SchedulingProblemGeneratorArgs:
    shared_folder: str = "data/problem_set_r5_t10_s10_f80_w50_euc_2000"
    """the folder where the shared paths are stored"""
    seed: int = 10
    """the seed for the random number generator"""
    config_file: str = "data/problem_r5_t10_s10_f80_w50_config.json"
    """the configuration file for the problem"""
    start_problem: int = 1
    """the starting problem number"""
    end_problem: int = 2000
    """the ending problem number"""
    file_prefix: str = "problem_"
    """the prefix for the problem file names"""
    travel_mode: str = "euclidean"
    """the travel mode for the environment (euclidean, manhattan or rrg). 
    RRG Mode handles shared paths and includes additional constraint 
    checking to allow for the presence of paths from each robot and task 
    location to the task locations."""

if __name__ == "__main__":
    print("Generating problems for the scheduling environment.")
    args = tyro.cli(SchedulingProblemGeneratorArgs)
    set_seed(args.seed)
    # if the folder does not exist, create it
    if not os.path.exists(args.shared_folder):
        os.makedirs(args.shared_folder)
    for i in range(args.start_problem, args.end_problem + 1):
        set_seed(args.seed + i)
        print(f"Generating problem {i}...")
        save_path = os.path.join(args.shared_folder, f"{args.file_prefix}{str(i).zfill(5)}.json")
        env = SchedulingEnvironment(save_path, generator_config=args.config_file, mode='euclidean', verbose=True)
        print(f"Problem {i} is generated successfully.")
    print("All problems are generated successfully.")
    