"""
author: Anonymous
"""
import os
import sys
import inspect

currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
sys.path.insert(0, parentdir) 

import math
import numpy as np
from scheduling.location import Location

class Obstacle(object):
    def __init__(self, x, y, radius, map_size = (100, 100)) -> None:
        super().__init__()
        self.location = Location(x, y)
        self.radius = radius
        self.map_size = map_size
        
    def reset(self):
        return self.get_observation()
        
    def get_observation(self):
        # return an np.array of features
        feature = [
            self.location.x / self.map_size[0], 
            self.location.y / self.map_size[1], 
            self.radius / math.sqrt(self.map_size[0] ** 2 + self.map_size[1] ** 2)
        ]
        return np.array(feature)
    
    def deep_copy(self, source):
        self.location = source.location
        self.radius = source.radius
        self.map_size = source.map_size
        
        
    @staticmethod
    def get_feature_size():
        # A Singleton Function to return the size of the feature space for a single Agent
        return 3
        
    def get_location(self):
        return self.location.get_location()
    
    def __dict__(self):
        return {
            'x': self.location.x,
            'y': self.location.y,
            'radius': self.radius
        }
    
    def has_collision(self, start, end, mode='euclidean'):
        """Check if the line between the two points passes through the obstacle. This is the implementation for the circular obstacles.
        TODO: When changing the Obstacle Structure, add a new method for the new structure.
        Args:
            point (Location): The start point of the line
            other_point (Location): The end point of the line
        Returns:
            bool: True if the line passes through the obstacle, False otherwise
        """
        # project the center of the obstacle onto the line
        projected_point = self.location.project_onto_line(start, end)
        # if the cumilative distance from the two points is equal to the distance between the two points, than the projected point is within the line segment
        if math.isclose(projected_point.distance(start, mode=mode) + projected_point.distance(end, mode=mode), start.distance(end, mode=mode), rel_tol=1e-9):
            # check if the distance from the center of the obstacle to the line is less than the radius of the obstacle
            if projected_point.distance(self.location, mode=mode) <= self.radius:
                return True
        else:
            # check if the distance from the center of the obstacle and the end points are less than the radius of the obstacle
            p1_distance = start.distance(self.location, mode=mode)
            p2_distance = end.distance(self.location, mode=mode)
            if p1_distance <= self.radius or p2_distance <= self.radius:
                return True
        return False
    