"""
author: Anonymous
"""

import os
import sys
import inspect

currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
sys.path.insert(0, parentdir) 

import numpy as np
from scheduling.location import Location
   
class Task(object):
    def __init__(self, id, x, y, start_time = 0, end_time = 0):
        super().__init__()
        self.id = id
        self.location = Location(x, y)
        self.start_time = start_time
        self.end_time = end_time
        self.reset()
    
    def reset(self):
        self.assigned_agent = None
        self.expected_completion_time = None
        self.task_will_complete = False
        
    def get_observation(self, deadline):
        # return an np.array of features
        return np.array([
            self.start_time / deadline, 
            self.end_time / deadline, 
            1.0 if self.assigned_agent is not None else 0.0,
            # 1.0 if self.task_will_complete else 0.0,
            self.expected_completion_time / deadline if self.expected_completion_time is not None else -1.0
        ])
    
    def step(self, action, expected_completion_time, task_will_complete = False):
        if self.assigned_agent is not None:
            return False
        # Assign the task to the unit
        self.assigned_agent = action.id
        self.expected_completion_time = expected_completion_time
        self.task_will_complete = task_will_complete
        return True
        
    def deep_copy(self, source):
        self.id = source.id
        self.location = source.location
        self.start_time = source.start_time
        self.end_time = source.end_time
        self.assigned_agent = source.assigned_agent
        self.expected_completion_time = source.expected_completion_time
        self.task_will_complete = source.task_will_complete
        
    @staticmethod
    def get_feature_size():
        # A Singleton Function to return the size of the feature space for a single Task
        return 4 # 5
    
    @staticmethod
    def get_task_start_time_index():
        return 0
    
    @staticmethod
    def get_task_end_time_index():
        return 1
    
    @staticmethod
    def get_task_assigned_agent_index():
        return 2
    
    @staticmethod
    def get_task_expected_completion_time_index():
        return 3
    
    def __dict__(self):
        return {
            'id': self.id,
            'x': self.location.x,
            'y': self.location.y,
            'start_time': self.start_time,
            'end_time': self.end_time
        }
    
    @staticmethod
    def get_feature_space():
        return [
            "Start Time",
            "End Time",
            "Agent is assigned",
            "Expected Completion Time"
        ]