#!/bin/bash

SESSION_NAME="targetnet_train_neurips25_final1"

# Check if the session already exists
if tmux has-session -t $SESSION_NAME 2>/dev/null; then
    echo "Session $SESSION_NAME already exists. Attaching to it."
    tmux attach-session -t $SESSION_NAME
else
    # Create a new session and name it
    tmux new-session -d -s $SESSION_NAME
    
    declare -a MODELS=("hetgat" "hetgat_resnet" "hgt" "hgt_edge" "hgt_edge_resnet")
    declare -a SEEDS=(10 11 12)
    declare -a CRITIC_MODE=("" "-no_critic")

    # 10 Robot 20 Task 200 Problems
    for critic_choice in "${CRITIC_MODE[@]}"
    do
        critic="makespan-atari${critic_choice}"
        for model in "${MODELS[@]}"
        do
            name="${model}${critic_choice}"
            tmux new-window -n $name
            tmux split-window -h
            tmux split-window -h
            tmux select-layout even-horizontal
            for seed in "${SEEDS[@]}"
            do
                index=$(($seed - 10 + 1))
                tmux send-keys -t $name.$index 'export PYTHONHASHSEED=0' C-m # ensures full reprodibility and internal consistency
                tmux send-keys -t $name.$index "index=${index}" C-m
                tmux send-keys -t $name.$index "seed=${seed}" C-m
                tmux send-keys -t $name.$index 'echo "Hello from pane ${index}"' C-m
                tmux send-keys -t $name.$index 'conda activate targetnet' C-m
                tmux send-keys -t $name.$index "model=${model}" C-m
                tmux send-keys -t $name.$index "critic=${critic}" C-m
                tmux send-keys -t $name.$index 'python training/sac_wip.py --env_location data/problem_set_r10_t20_s0_f10_w25_euc_2000_uni --end_problem 200 --env_id "paper neurips25 10r20t0s10f25w200p ${model} ${critic} reward-greedy-final1" --num_heads 8 --num_layers 4 --no-partition_learning --reward_mode ${critic} --critic_mode ${model} --graph_mode ${model} --no-baseline_boosting --seed ${seed} --adaptive_temperature' C-m
            done
        done

        model="hgt_edge_resnet_bb"
        name="${model}${critic_choice}"
        tmux new-window -n $name
        tmux split-window -h
        tmux split-window -h
        tmux select-layout even-horizontal
        for seed in "${SEEDS[@]}"
        do
            index=$(($seed - 10 + 1))
            tmux send-keys -t $name.$index 'export PYTHONHASHSEED=0' C-m # ensures full reprodibility and internal consistency
            tmux send-keys -t $name.$index "index=${index}" C-m
            tmux send-keys -t $name.$index "seed=${seed}" C-m
            tmux send-keys -t $name.$index 'echo "Hello from pane ${index}"' C-m
            tmux send-keys -t $name.$index 'conda activate targetnet' C-m
            tmux send-keys -t $name.$index "model=${model}" C-m
            tmux send-keys -t $name.$index "critic=${critic}" C-m
            tmux send-keys -t $name.$index 'python training/sac_wip.py --env_location data/problem_set_r10_t20_s0_f10_w25_euc_2000_uni --end_problem 200 --env_id "paper neurips25 10r20t0s10f25w200p hgt-edge-resnet wbb ${critic} reward-greedy-final1" --num_heads 8 --num_layers 4 --no-partition_learning --reward_mode ${critic} --critic_mode $model --graph_mode $model --seed ${seed}' C-m
        done


        model="hgt_edge_resnet"
        name="simultaneous_${model}${critic_choice}"
        tmux new-window -n $name
        tmux split-window -h
        tmux split-window -h
        tmux select-layout even-horizontal
        for seed in "${SEEDS[@]}"
        do
            index=$(($seed - 10 + 1))
            tmux send-keys -t $name.$index 'export PYTHONHASHSEED=0' C-m # ensures full reprodibility and internal consistency
            tmux send-keys -t $name.$index "index=${index}" C-m
            tmux send-keys -t $name.$index "seed=${seed}" C-m
            tmux send-keys -t $name.$index 'echo "Hello from pane ${index}"' C-m
            tmux send-keys -t $name.$index 'conda activate targetnet' C-m
            tmux send-keys -t $name.$index "model=${model}" C-m
            tmux send-keys -t $name.$index "critic=${critic}" C-m
            tmux send-keys -t $name.$index 'python training/sac_wip_simultaneous.py --env_location data/problem_set_r10_t20_s0_f10_w25_euc_2000_uni --end_problem 200 --env_id "paper neurips25 10r20t0s10f25w200p hgt-edge-resnet sim ${critic} reward-greedy-final1" --num_heads 8 --num_layers 4 --no-partition_learning --reward_mode ${critic} --critic_mode $model --graph_mode $model --seed ${seed}' C-m
    done
    # Attach to the created session
    tmux attach-session -t $SESSION_NAME
fi

