#!/bin/bash

SESSION_NAME="targetnet_train_rss2025_final_exp_simultaneous_scheduler_no_eps"

# Check if the session already exists
if tmux has-session -t $SESSION_NAME 2>/dev/null; then
    echo "Session $SESSION_NAME already exists. Attaching to it."
    tmux attach-session -t $SESSION_NAME
else
    # Create a new session and name it
    tmux new-session -d -s $SESSION_NAME
    
    declare -a MODELS=("hgt" "hgt_edge" "hgt_edge_resnet")
    # declare -a MODELS=("hgt_edge_resnet") # Test run
    declare -a SEEDS=(10 11 12)
    declare -a CRITIC_MODE=("")

    # 10 Robot 20 Task 200 Problems
    for model in "${MODELS[@]}"
    do
        name="${model}${critic_choice}"
        tmux new-window -n $name
        tmux split-window -h
        tmux split-window -h
        tmux select-layout even-horizontal
        for seed in "${SEEDS[@]}"
        do
            index=$(($seed - 10 + 1))
            tmux send-keys -t $name.$index 'export PYTHONHASHSEED=0' C-m # ensures full reprodibility and internal consistency
            tmux send-keys -t $name.$index "index=${index}" C-m
            tmux send-keys -t $name.$index "seed=${seed}" C-m
            tmux send-keys -t $name.$index 'echo "Hello from pane ${index}"' C-m
            tmux send-keys -t $name.$index 'conda activate targetnet' C-m
            tmux send-keys -t $name.$index "model=${model}" C-m
            tmux send-keys -t $name.$index "critic=${critic}" C-m
            tmux send-keys -t $name.$index 'python training/sac_wip_simultaneous.py --env_location data/problem_set_r10_t20_s0_f10_w25_euc_2000_uni --end_problem 200 --env_id "paper aamas25 10r20t0s10f25w200p ${model} simultaneous reward-greedy-final1" --num_heads 1 --num_layers 4 --no-partition_learning --graph_mode ${model} --baseline_boosting --seed ${seed} --adaptive_temperature --track --gamma 0.95' C-m
        done
    done

    # Attach to the created session
    tmux attach-session -t $SESSION_NAME
fi

