"""
author: Anonymous
"""
import os
import sys
import inspect

currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
sys.path.insert(0, parentdir) 

import numpy as np

from solvers.improved_edf import ImprovedEarliestDeadlineFirstAgent

from scheduling.environment import SchedulingEnvironment
from scheduling.agent import Agent
from utils.edge_space import EdgeInstance

from utils.utils import set_seed

import unittest

class ImprovedEarliestDeadlineFirstUnitTest(unittest.TestCase):
    def setY(self):
        pass
    
    def test_basic(self):
        self.assertEqual(Agent.agent_current_makespan_index(), 1)
        observation = {
            'agent': np.array([[0.5, 1.5, 0.5, 0.5],
                               [1.0, 1.0, 1.0, 1.0]]),
            'agent_to_task_assignment': EdgeInstance(
                source_nodes=np.array([0, 0, 1, 1]),
                target_nodes=np.array([0, 1, 0, 1]),
                edge_features=np.array([[9, 10], [10, 10], [9, 10], [10, 10]])
            ),
            'task_to_task_select': EdgeInstance(
                source_nodes=np.array([0, 1]),
                target_nodes=np.array([0, 1]),
                edge_features=None
            ),
            'wait_time': EdgeInstance(
                source_nodes=np.array([]),
                target_nodes=np.array([]),
                edge_features=np.array([])
            )
        }
        
        agent = ImprovedEarliestDeadlineFirstAgent()
        task_id, agent_id = agent.get_action(observation)

        self.assertEqual(task_id, 0)
        self.assertEqual(agent_id, 1)
        
    # def test_assigned(self):
    #     self.assertEqual(Agent.agent_current_makespan_index(), 1)
    #     observation = {
    #         'agent': np.array([[0.5, 1.5, 0.5, 0.5],
    #                            [0.5, 1.5, 0.5, 0.5],
    #                            [1.0, 1.0, 1.0, 1.0]]),
    #         'agent_to_task_assignment': EdgeInstance(
    #             source_nodes=np.array([0, 0, 0, 1, 1, 1]),
    #             target_nodes=np.array([0, 1, 2, 0, 1, 2]),
    #             edge_features=np.array([[9, 10], [10, 10], [9, 10], [10, 10], [10, 10], [10, 10]])
    #         ),
    #         'task_to_task_select': EdgeInstance(
    #             source_nodes=np.array([0, 2]),
    #             target_nodes=np.array([0, 1]),
    #             edge_features=None
    #         )
    #     }
        
    #     agent = EarliestDeadlineFirstAgent()
    #     task_id, agent_id = agent.get_action(observation)

    #     self.assertEqual(task_id, 0)
    #     self.assertEqual(agent_id, 1)
        
    def test_environment(self):
        set_seed(10)
        save_location = os.path.join(parentdir, 'test/sample_problem_5_10_example.json')
        env = SchedulingEnvironment(save_location, mode='euclidean')
        obs, _ = env.reset()
        agent = ImprovedEarliestDeadlineFirstAgent()
        task_id, agent_id = agent.get_action(obs)
        self.assertEqual(task_id, 1)
        self.assertEqual(agent_id, 0)
        
        
        obs, _, _, _ = env.step((0, 0))
        task_id, agent_id = agent.get_action(obs)
        

if __name__ == '__main__':
    unittest.main()