
import os
import sys
import inspect

currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
sys.path.insert(0, parentdir) 

from path_planning.path import Path
from scheduling.location import Location

import unittest
class TestEdge(unittest.TestCase):
    def setUp(self):
        self.path = Path([
            Location(0, 0),
            Location(1, 1),
            Location(2, 2),
            Location(3, 3)])
        
    def test_intersection(self):
        other_path = Path([
            Location(0, 0),
            Location(1, 1),
            Location(2, 2),
            Location(3, 3)])
        self.assertEqual(self.path, other_path)
        self.assertEqual(self.path.intersection(other_path), self.path.edges)
        
        other_path = Path([
            Location(0, 0),
            Location(1, 1),
            Location(2, 2),
            Location(4, 4)])
        self.assertEqual(self.path.intersection(other_path), self.path.edges[:-1])
        
        other_path = Path([
            Location(0, 0),
            Location(1, 1),
            Location(4, 4),
            Location(5, 5)])
        self.assertEqual(self.path.intersection(other_path), self.path.edges[:1])
        
        other_path = Path([
            Location(0, 0),
            Location(4, 4),
            Location(5, 5),
            Location(6, 6)])
        self.assertEqual(self.path.intersection(other_path), [])
    
if __name__ == '__main__':
    unittest.main(argv=[''], exit=False)