"""
author: Anonymous
"""
import os
import sys
import inspect

currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
sys.path.insert(0, parentdir) 

import numpy as np

import unittest
from scheduling.environment import SchedulingEnvironment
from path_planning.rrg import RRG
from utils.utils import set_seed

class TestRRG(unittest.TestCase):
    def setUp(self):
        self.env = SchedulingEnvironment(config_file="test/sample_problem_5_10_example.json", mode='euclidean')
        self.rrg = RRG(self.env)
    
    def test_generate_paths(self):
        set_seed(10)
        self.rrg.generate_paths()
        self.rrg.render()
        
        self.assertTrue(self.rrg.agent_to_task_paths)
        self.assertTrue(self.rrg.task_to_task_paths)
        self.assertTrue(self.rrg.graph)
        
    def test_rrg_save(self):
        set_seed(11)
        self.rrg.save()
        self.rrg.load()
        
        self.assertTrue(self.rrg.agent_to_task_paths)
        self.assertTrue(self.rrg.task_to_task_paths)
        self.assertTrue(self.rrg.graph)
        
    def test_rrg_shared_paths(self):
        set_seed(10)
        self.rrg.generate_paths()
        self.rrg.find_shared_edges()
        
        # self.assertTrue(self.rrg.shared_paths_graph)
        
    def test_rrg_with_scheduler_single_agent(self):
        set_seed(10)
        self.rrg.generate_paths()
        for t in self.rrg.env.tasks:
            a = self.rrg.env.agents[0]
            self.rrg.env.agents[0].assigned_tasks.append(t)
        self.rrg.render('figures/rrg_with_schedule_to_single_agent.png')
        
    def test_rrg_with_scheduler_multi_agent(self):
        set_seed(12)
        self.rrg.generate_paths()
        for t in self.rrg.env.tasks:
            # randomly select an agent from agents list
            a = np.random.choice(len(self.rrg.env.agents))
            self.rrg.env.agents[a].assigned_tasks.append(t)
        self.rrg.render('figures/rrg_with_schedule.png')
        
if __name__ == '__main__':
    unittest.main(argv=[''], exit=False)
