#!/bin/bash
# tmux start-server
SESSION_NAME="targetnet_evaluate_neurips25_sim_no_ent"
# Check if the session already exists
if tmux has-session -t $SESSION_NAME 2>/dev/null; then
    echo "Session $SESSION_NAME already exists. Attaching to it."
    tmux attach-session -t $SESSION_NAME
else
    # Create a new session and name it
    tmux new-session -d -s $SESSION_NAME
    
    COMMANDS=(
        "python evaluation/evaluation_simultaneous.py --start_problem 1 --end_problem 200 --env_location data/problem_set_r10_t20_s0_f10_w25_euc_200_test --initial_performance"
        "python evaluation/evaluation_simultaneous.py --start_problem 1 --end_problem 200 --env_location data/problem_set_r10_t20_s0_f10_w25_euc_200_test"
        "python evaluation/evaluation_simultaneous.py --start_problem 1 --end_problem 200 --env_location data/problem_set_r10_t50_s0_f10_w25_euc_2000_uni"
        "python evaluation/evaluation_simultaneous.py --start_problem 1 --end_problem 30 --env_location data/problem_set_r20_t100_s0_f10_w25_euc_200"
        "python evaluation/evaluation_simultaneous.py --start_problem 1 --end_problem 10 --env_location data/problem_set_r40_t200_s0_f10_w25_euc_200"
        # "python evaluation/evaluation.py --start_problem 1 --end_problem 10 --env_location data/problem_set_r80_t400_s0_f10_w25_euc_200"
        # Ablations
        ## 10 robot 20 task [5% time window] 25% wait time
        "python evaluation/evaluation_simultaneous.py --start_problem 1 --end_problem 200 --env_location data/problem_set_r10_t20_s0_f5_w25_euc_2000"
        ## 10 robot 20 tasks [10% time window] 25% wait time
        "python evaluation/evaluation_simultaneous.py --start_problem 1 --end_problem 200 --env_location data/problem_set_r10_t20_s5_f10_w25_euc_2000"
        ## 10 robot 20 task 10% time window [No wait time]
        "python evaluation/evaluation_simultaneous.py --start_problem 1 --end_problem 200 --env_location data/problem_set_r10_t20_s0_f10_w0_euc_2000"
        ## 10 robot 20 task 10% time window [50% wait time]
        "python evaluation/evaluation_simultaneous.py --start_problem 1 --end_problem 200 --env_location data/problem_set_r10_t20_s0_f10_w50_euc_2000"

        ## 10 robot 20 task 10% time window 25% wait time fast
        "python evaluation/evaluation_simultaneous.py --start_problem 1 --end_problem 200 --env_location data/problem_set_r10_t20_s0_f10_w25_euc_2000_test_fast"
        ## 10 robot 20 task 10% time window 25% wait time slow
        "python evaluation/evaluation_simultaneous.py --start_problem 1 --end_problem 200 --env_location data/problem_set_r10_t20_s0_f10_w25_euc_2000_test_slow"
        )
    i=0
    for command in "${COMMANDS[@]}"
    do
        i=$((i+1))
        name="eval_${i}"
        tmux new-window -n $name
        tmux send-keys -t $name 'export PYTHONHASHSEED=0' C-m # ensures full reprodibility and internal consistency
        tmux send-keys -t $name 'echo "Hello from pane ${i}"' C-m
        tmux send-keys -t $name 'conda activate targetnet' C-m
        tmux send-keys -t $name "${command}" C-m
    done

    # Attach to the created session
    tmux attach-session -t $SESSION_NAME
fi
