#!/bin/bash
# run the following in Tmux in parallel

SESSION_NAME="targetnet_generate_aamas25"
# Check if the session already exists
if tmux has-session -t $SESSION_NAME 2>/dev/null; then
    echo "Session $SESSION_NAME already exists. Attaching to it."
    tmux attach-session -t $SESSION_NAME
else
    # Create a new session and name it
    tmux new-session -d -s $SESSION_NAME
    
    COMMANDS=(
    ## (AAMAS2025)
    # 10 robot 20 task 10% time window 25% wait time
    "python scheduling/generate_problems.py --shared_folder data/problem_set_r10_t20_s0_f10_w25_euc_2000_uni --config_file data/problem_r10_t20_s0_f10_w25_config.json --start_problem 1 --end_problem 2000 --seed 10"
    ###########################
    # 10 robot 20 task 10% time window 25% wait time
    "python scheduling/generate_problems.py --shared_folder data/problem_set_r10_t20_s0_f10_w25_euc_2000_test --config_file data/problem_r10_t20_s0_f10_w25_config.json --start_problem 1 --end_problem 2000 --seed 2000"
    # 10 robot 50 task 10% time window 25% wait time
    "python scheduling/generate_problems.py --shared_folder data/problem_set_r10_t50_s0_f10_w25_euc_2000_uni --config_file data/problem_r10_t50_s0_f10_w25_config.json --start_problem 1 --end_problem 2000 --seed 10"
    # 20 robot 100 task 10% time window 25% wait time -> 50 Problems
    "python scheduling/generate_large_problems.py --shared_folder data/problem_set_r20_t100_s0_f10_w25_euc_200 --config_file data/problem_r10_t50_s0_f10_w25_config.json --number_of_agents 20 --number_of_tasks 100 --tmp_location data/tmp_r20_t100_s0_f10_w25 --start_problem 1 --end_problem 200 --seed 10"
    # 40 robot 200 task 10% time window 25% wait time -> 50 Problems
    "python scheduling/generate_large_problems.py --shared_folder data/problem_set_r40_t200_s0_f10_w25_euc_200 --config_file data/problem_r10_t50_s0_f10_w25_config.json --number_of_agents 40 --number_of_tasks 200 --tmp_location data/tmp_r40_t200_s0_f10_w25 --start_problem 1 --end_problem 200 --seed 10"
    # 80 robot 400 task 10% time window 25% wait time -> 50 Problems (Stretch)
    "python scheduling/generate_large_problems.py --shared_folder data/problem_set_r80_t400_s0_f10_w25_euc_200 --config_file data/problem_r10_t50_s0_f10_w25_config.json --number_of_agents 40 --number_of_tasks 200 --tmp_location data/tmp_r80_t400_s0_f10_w25 --start_problem 1 --end_problem 200 --seed 10"
    ## Ablations
    # 10 robot 20 task 10% time window 25% wait time [1000x1000 map]
    "python scheduling/generate_problems.py --shared_folder data/problem_set_r10_t20_s0_f10_w25_euc_2000_large --config_file data/problem_r10_t20_s0_f10_w25_large_config.json --start_problem 1 --end_problem 200 --seed 10"
    # 10 robot 20 task [5% time window] 25% wait time
    "python scheduling/generate_problems.py --shared_folder data/problem_set_r10_t20_s0_f5_w25_euc_2000 --config_file data/problem_r10_t20_s0_f5_w25_config.json --start_problem 1 --end_problem 200 --seed 10"
    # 10 robot 20 tasks [20% time window] 25% wait time
    "python scheduling/generate_problems.py --shared_folder data/problem_set_r10_t20_s0_f20_w25_euc_2000 --config_file data/problem_r10_t20_s0_f20_w25_config.json --start_problem 1 --end_problem 200 --seed 10"
    # 10 robot 20 tasks [No time Window] 25% wait time
    "python scheduling/generate_problems.py --shared_folder data/problem_set_r10_t20_s100_f100_w25_euc_2000 --config_file data/problem_r10_t20_s100_f100_w25_config.json --start_problem 1 --end_problem 200 --seed 10"
    # 10 robot 20 task 10% time window [No wait time]
    "python scheduling/generate_problems.py --shared_folder data/problem_set_r10_t20_s0_f10_w0_euc_2000 --config_file data/problem_r10_t20_s0_f10_w0_config.json --start_problem 1 --end_problem 200 --seed 10"
    # 10 robot 20 task 10% time window [50% wait time]
    "python scheduling/generate_problems.py --shared_folder data/problem_set_r10_t20_s0_f10_w50_euc_2000 --config_file data/problem_r10_t20_s0_f10_w50_config.json --start_problem 1 --end_problem 200 --seed 10"
    )

    i=0
    for command in "${COMMANDS[@]}"
    do	
        i=$((i+1))
        # name=i # "${i}"
        tmux new-window -n $i 
        tmux send-keys -t $i.0 'export PYTHONHASHSEED=0' C-m # ensures full reprodibility and internal consistency
        tmux send-keys -t $i.0 'echo "Hello from pane ${i}"' C-m
        tmux send-keys -t $i.0 'conda activate targetnet' C-m
        tmux send-keys -t $i.0 "${command}" C-m
    done

    # Attach to the created session
    tmux attach-session -t $SESSION_NAME
fi
