"""
author: Anonymous
"""
import math
import numpy as np

class Location():
    def __init__(self, x:int = 0, y:int = 0):
        super().__init__()
        self.x = x
        self.y = y
        
    def get_location(self):
        return np.array([self.x, self.y])
    
    def __repr__(self):
        return f"Location ({self.x}, {self.y})"
    
    def __eq__(self, other):
        if isinstance(other, Location):
            return self.x == other.x and self.y == other.y
        return False
    
    # hash function for the Location class
    def __hash__(self):
        return hash((self.x, self.y))
    
    # Comparison between two locations
    def __lt__(self, other):
        if self.x < other.x:
            return True
        elif self.x == other.x:
            return self.y < other.y
        else:
            return False
    
    def __le__(self, other):
        if self.x < other.x:
            return True
        elif self.x == other.x:
            return self.y <= other.y
        else:
            return False
    
    def __gt__(self, other):
        if self.x > other.x:
            return True
        elif self.x == other.x:
            return self.y > other.y
        else:
            return False
    
    def __ge__(self, other):
        if self.x > other.x:
            return True
        elif self.x == other.x:
            return self.y >= other.y
        else:
            return False
    
    def __str__(self) -> str:
        return f"({self.x}, {self.y})"
    
    @staticmethod
    def from_str(string):
        x, y = string[1:-1].split(',')
        return Location(int(x), int(y))
    
    def distance(self, other, mode = 'euclidean'):
        if mode == 'euclidean':
            return math.sqrt((self.x - other.x) ** 2 + (self.y - other.y) ** 2)
        else:
            raise NotImplementedError
   
    def project_onto_line(self, start_point, end_point):
        """Project the point onto the line between the start and end points"""
        # calculate the projection of the point onto the line
        start_point = np.array(start_point.get_location())
        end_point = np.array(end_point.get_location())
        diff = end_point - start_point
        point = np.array(self.get_location())
        try:
            u = np.dot(point - start_point, diff) / np.dot(diff, diff)
        except RuntimeWarning:
            print(f"point: {point}, start_point: {start_point}, end_point: {end_point}, diff: {diff}")
            print(f"point - start_point: {point - start_point}, diff: {diff}")
            print(f"np.dot(point - start_point, diff): {np.dot(point - start_point, diff)}, np.dot(diff, diff): {np.dot(diff, diff)}")    
        projection = start_point + u * diff
        return Location(projection[0], projection[1])
    
    
import unittest
class TestLocation(unittest.TestCase):
    def test_distance(self):
        loc1 = Location(0, 0)
        loc2 = Location(3, 4)
        self.assertEqual(loc1.distance(loc2), 5)
        
    def test_project_onto_line(self):
        loc1 = Location(0, 0)
        loc2 = Location(3, 4)
        loc3 = Location(1, 1)
        projected_point = loc3.project_onto_line(loc1, loc2).get_location()
        self.assertEqual(projected_point.shape, (2, ))
        self.assertAlmostEqual(projected_point[0], 0.84)
        self.assertAlmostEqual(projected_point[1], 1.12)
        
    
    def test_get_location(self):
        loc = Location(1, 2)
        
        self.assertTrue(np.array_equal(loc.get_location(), np.array([1, 2])))

if __name__ == "__main__":
    unittest.main(argv=[''], exit=False)