"""
author: Anonymous
"""
import os
import sys
import inspect

currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
sys.path.insert(0, parentdir) 

import numpy as np

from solvers.edf import EarliestDeadlineFirstAgent

from scheduling.environment import SchedulingEnvironment
from scheduling.agent import Agent
from utils.edge_space import EdgeInstance

from utils.utils import set_seed

import unittest

class EarliestDeadlineFirstUnitTest(unittest.TestCase):
    def setY(self):
        pass
    
    def test_basic(self):
        self.assertEqual(Agent.agent_current_makespan_index(), 1)
        observation = {
            'agent': np.array([[0.5, 1.5, 0.5, 0.5],
                               [1.0, 1.0, 1.0, 1.0]]),
            'agent_to_task_assignment': EdgeInstance(
                source_nodes=np.array([0, 0, 1, 1]),
                target_nodes=np.array([0, 1, 0, 1]),
                edge_features=np.array([[9], [10], [9], [10]])
            ),
            'task_to_task_select': EdgeInstance(
                source_nodes=np.array([0, 1]),
                target_nodes=np.array([0, 1]),
                edge_features=None
            ),
            'task_assignment': np.array([[10],
                                         [10],
                                         [10],
                                         [10]])
        }
        
        agent = EarliestDeadlineFirstAgent()
        task_id, agent_id = agent.get_action(observation)[0]

        self.assertEqual(task_id, 0)
        self.assertEqual(agent_id, 1)
        
    # def test_assigned(self):
    #     self.assertEqual(Agent.agent_current_makespan_index(), 1)
    #     observation = {
    #         'agent': np.array([[0.5, 1.5, 0.5, 0.5],
    #                            [0.5, 1.5, 0.5, 0.5],
    #                            [1.0, 1.0, 1.0, 1.0]]),
    #         'agent_to_task_assignment': EdgeInstance(
    #             source_nodes=np.array([0, 0, 0, 1, 1, 1]),
    #             target_nodes=np.array([0, 1, 2, 0, 1, 2]),
    #             edge_features=np.array([[9, 10], [10, 10], [9, 10], [10, 10], [10, 10], [10, 10]])
    #         ),
    #         'task_to_task_select': EdgeInstance(
    #             source_nodes=np.array([0, 2]),
    #             target_nodes=np.array([0, 1]),
    #             edge_features=None
    #         )
    #     }
        
    #     agent = EarliestDeadlineFirstAgent()
    #     task_id, agent_id = agent.get_action(observation)

    #     self.assertEqual(task_id, 0)
    #     self.assertEqual(agent_id, 1)
        
    def test_environment(self):
        set_seed(10)
        save_location = os.path.join(parentdir, 'test/sample_problem_5_10_example.json')
        env = SchedulingEnvironment(save_location, mode='euclidean')
        obs, _ = env.reset()
        agent = EarliestDeadlineFirstAgent()
        task_id, agent_id = agent.get_action(obs)[0]
        self.assertEqual(task_id, 5)
        self.assertEqual(agent_id, 0)
        
        
        obs, _, _, _ = env.step((0, 0))
        task_id, agent_id = agent.get_action(obs)[0]
        
    def test_consistency(self):
        set_seed(10)
        save_location = os.path.join(parentdir, 'test/sample_problem_5_10_example.json')
        env = SchedulingEnvironment(save_location, mode='euclidean')
        obs, _ = env.reset()
        agent = EarliestDeadlineFirstAgent()
        task_id, agent_id = agent.get_action(obs)[0]
        self.assertEqual(task_id, 5)
        self.assertEqual(agent_id, 0)
        set_seed(11)
        env = SchedulingEnvironment(save_location, mode='euclidean')
        obs, _ = env.reset()
        agent = EarliestDeadlineFirstAgent()
        task_id_2, agent_id_2 = agent.get_action(obs)[0]
        
        self.assertEqual(task_id, task_id_2)
        self.assertEqual(agent_id, agent_id_2)

if __name__ == '__main__':
    unittest.main()