"""
author: Anonymous
"""
import os
import sys
import inspect

currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
sys.path.insert(0, parentdir) 


from training.replay_buffer import ReplayBuffer

import unittest
class TestReplayBuffer(unittest.TestCase):
    def setUp(self):
        self.buffer = ReplayBuffer(10)
        
    def test_append(self):
        self.buffer.clear()
        self.buffer.append(1, 2, 3, 4, 5)
        self.assertEqual(self.buffer.size(), 1)
        self.buffer.append(1, 2, 3, 4, 5)
        self.assertEqual(self.buffer.size(), 2)
        self.buffer.append(1, 2, 3, 4, 5)
        self.assertEqual(self.buffer.size(), 3)
    
    def test_sample(self):
        self.buffer.clear()
        self.buffer.append(1, 2, 3, 4, 5)
        self.buffer.append(1, 2, 3, 4, 5)
        self.buffer.append(1, 2, 3, 4, 5)
        samples = self.buffer.sample(2)
        self.assertEqual(len(samples), 2)
        samples = self.buffer.sample(2)
        self.assertEqual(len(samples), 2)
        samples = self.buffer.sample(2)
        self.assertEqual(len(samples), 2)
        
    def test_clear(self):
        self.buffer.clear()
        self.buffer.append(1, 2, 3, 4, 5)
        self.buffer.append(1, 2, 3, 4, 5)
        self.buffer.append(1, 2, 3, 4, 5)
        self.buffer.clear()
        self.assertEqual(self.buffer.size(), 0)
        
    def test_size(self):
        self.buffer.clear()
        self.assertEqual(self.buffer.size(), 0)
        self.buffer.append(1, 2, 3, 4, 5)
        self.assertEqual(self.buffer.size(), 1)
        self.buffer.append(1, 2, 3, 4, 5)
        self.assertEqual(self.buffer.size(), 2)
        self.buffer.append(1, 2, 3, 4, 5)
        self.assertEqual(self.buffer.size(), 3)
        self.buffer.clear()
        self.assertEqual(self.buffer.size(), 0)

if __name__ == '__main__':
    unittest.main()
    