## Unified, Practical, and White-box Seismic Tomography with Automatic Differentiation

This repository is for the ICLR 2026 submission.

We use low-level automatic differentiation to unify seismic imaging, providing a platform that implements seismic imaging methods without any manual derivation or neural network training.

Common seismic imaging methods (time/frequency domains, acoustic/SH/P-SV/visco-acoustic/visco-elastic  waves, and waveform/travel-time/attenuation misfits) are implemented by PyTorch, enabling researchers to directly test and extend our approach in the future.

Note: Viewing the GIF files in the tables may cause rendering issues in the **VS Code** markdown. Please use another markdown viewer to avoid this problem.

## Results

#### 1. Forward Simulations


|   Wave   |                                               Time Domain                                               |
| :------: | :-----------------------------------------------------------------------------------------------------: |
| Acoustic | <img src="fig_results/Acoustic_TD/wavefield_freesurface.gif" alt="acousticForward" style="zoom:40%;" /> |
|    SH    |     <img src="fig_results/SH_TD/sh_wavefield_freesurface.gif" alt="SHForward" style="zoom:40%;" />     |
|   P-SV   |    <img src="fig_results/PSV_TD/psv_wavefield_freesurface.gif" alt="PSVForward" style="zoom:17%;" />    |


|        Wave        |                               **Frequency  Domain (attenuation)**                               |
| :----------------: | :----------------------------------------------------------------------------------------------: |
|   Visco-acoustic   | <img src="fig_results/Acoustic_FD/wavefield_illu.gif" alt="acousticForward" style="zoom:40%;" /> |
| Visco-elastic (SH) |       <img src="fig_results/SH_FD/wavefield_illu.gif" alt="SHForward" style="zoom:40%;" />       |

**Note**:

1. With free-surface conditions, the SH simulation produces a **Love surface wave** with energy concentrated in the top layer. Similarly, the P-SV simulation produces a retrograde elliptical **Rayleigh surface wave**. This aligns well with geophysical derivations and realistic obversions.
2. The differences between the time and frequency domain are mainly because

   (1) the frequency domain simulates the visco-acoustic or visco-elastic wave equations with attenuation, whereas the time domain does not include attenuation.

   (2) the source range of the frequency domain is wide, while that of the time domain is much more concentrated.

#### 2. Imaging

##### Time Domain


|   Wave   |                                                FWI$L_2$                                                |                                                  Travel Time                                                  |
| :------: | :----------------------------------------------------------------------------------------------------: | :------------------------------------------------------------------------------------------------------------: |
| Acoustic | <img src="fig_results/Acoustic_TD/inversion_process_L2.gif" alt="acousticForward" style="zoom:60%;" /> | <img src="fig_results/Acoustic_TD/inversion_process_traveltime.gif" alt="acousticForward" style="zoom:60%;" /> |
|    SH    |      <img src="fig_results/SH_TD/vs_inversion_L2.gif" alt="acousticForward" style="zoom:60%;" />      |      <img src="fig_results/SH_TD/vs_inversion_traveltime.gif" alt="acousticForward" style="zoom:60%;" />      |
|   P-SV   |      <img src="fig_results/PSV_TD/vs_inversion_L2.gif" alt="acousticForward" style="zoom:60%;" />      |        <img src="fig_results/PSV_TD/vs_inversion_travel.gif" alt="acousticForward" style="zoom:60%;" />        |

##### Frequency Domain


|        Wave        |                                                FWI$L_2$                                                |                                                  Attenuation                                                  |
| :----------------: | :----------------------------------------------------------------------------------------------------: | :-----------------------------------------------------------------------------------------------------------: |
|   Visco-acoustic   | <img src="fig_results/Acoustic_FD/inversion_process_L2.gif" alt="acousticForward" style="zoom:60%;" /> | <img src="fig_results/Acoustic_FD/inversion_process_att_dx100.gif" alt="acousticForward" style="zoom:60%;" /> |
| Visco-elastic (SH) |    <img src="fig_results/SH_FD/inversion_process_L2.gif" alt="acousticForward" style="zoom:60%;" />    |      <img src="fig_results/SH_FD/inversion_process_atten.gif" alt="acousticForward" style="zoom:60%;" />      |

#### 3. Love Wave Checkerboard Test in Nankai Subduction Zone

<img src="fig_results/SH_Checker/vs_inversion.gif" alt="acousticForward" style="zoom:80%;" />

## Requirements

**For time-domian seismic imaging:**

```setup
pip install -r requirements.txt
```

**To test the frequency-domian seismic imaging, please <u>DO NOT</u> use conda /pip to install PyTorch!**

Here we use NVIDIA cuDSS (A high-performance CUDA Library for Direct Sparse Solvers) to accelerate computation.

Please install PyTorch 2.7.0 following these steps **<u>from Source</u>, instead of conda / pip**:

- Install NVIDIA cuDSS from:

  https://developer.nvidia.com/cudss-downloads
- Install PyTorch **<u>from Source</u>**:

  https://github.com/pytorch/pytorch?tab=readme-ov-file#from-source

## Running the Code

Our examples are all given by **Jupyter Notebooks**.

```bash
/uniSIFolder/examples
├── 01-AcousticWave-Timedomain
├── 02-SH-Timedomain
├── 03-PSV-Timedomain
├── 04-AcousticWave-Freqdomain
├── 05-SH-Freqdomain
├── 06-OpenFWI-FlatVel
├── 06-OpenFWI-FlatFault
├── 06-OpenFWI-CurveVel
├── 06-OpenFWI-CurveFault
├── 06-OpenFWI-Style
├── 06-OpenFWI-Kimberlina
└── 07-SH-Timedomain-checkboard
```

**01 - 05** are basic demos and cross-scenarios expriments.

Each of them consists of:

- **Forward**:

  - 001-forward-demonstration.ipynb
    - Generate GIF for visualize wave propagation.
- **Inversion**:

  - 002-forward-inversionDataGen.ipynb

    - Run this notebook first to generate seismic recordings for inversion.
  - 002-inversion.ipynb

    - Load recordings and add noise.
    - Inversion here.
  - To reproduce the quantitative results in our manuscript, please run python code with according misfit function in each directory:

    ```
    python 002-inversion-L2.py
    or
    python 002-inversion-traveltime.py
    or 
    python 002-inversion-attenuation.py
    
    ```
- Result Visualization and Evaluation

  - 003-visualize.ipynb

    - Generate GIF for visualize inversion process.
    - Get SSIM/MS-SSIM metric.

**06** is experiment on the OpenFWI benchmark dataset. We selected the difficult sub-datasets: Vel-B, Fault-B and Style-B Family & Kimberlina CO2.

Each of them consists of:

- Imaging on OpenFWI:

  ```
  python openfwiEva.py
  ```
- Result Visualization and Evaluation

  - dataAnalysis.ipynb

**07** is a Love-wave checkerboard experiment in the Nankai subduction seismogenic zone.

## Assets

Our reaseach used these open-source assets. **Thanks so much for these excellent works and kind sharing.**

##### Baseline Codes:

- ADFWI

  - MIT License
  - Url: https://github.com/liufeng2317
- Matlab-based 2D visco-acoustic wave equation solver

  - Url: https://github.com/navid58/FDFD_ver02

##### Models and Datasets:

- Marmousi2 Model

  - Creative Commons Attribution 4.0 International (CC-BY-4.0)
  - Url: http://www.agl.uh.edu/downloads/downloads.htm
- OpenFWI Benchmark Dataset

  - BSD 3-Clause License
  - Url: https://smileunc.github.io/projects/openfwi/datasets
- Nanka Vp model

  - Paper Url: https://agupubs.onlinelibrary.wiley.com/doi/10.1029/2007JB004974
