"""
GNN Meta-Graph Fusion Framework
================================

This package provides tools for constructing, training, and evaluating
a multimodal graph neural network architecture with attention-based 
subgraph selection and meta-graph construction.

Modules
-------

- `lfp_dataset.py`:
    Loads and preprocesses LFP data from rats. Handles class balancing,
    node feature extraction, and graph construction using correlation-based edges.

- `dataset_simulated_setting1.py`:
    Generates synthetic graphs with modality-specific noise. Labels are based
    on important node features. Graph structure is created randomly.

- `dataset_simulated_setting2.py`:
    Gaussian Process-based simulation for generating modality-specific graphs.
    Labels are shared across modalities and constructed from non-linear rules.

- `train.py`:
    Trains models using 5-fold CV and evaluates test performance using the
    best Optuna hyperparameters. Includes final model testing on held-out fold.

- `train_utils.py`:
    Low-level training utilities including loss computation, accuracy, and
    instance-level weighting for boosting-style training strategies.

- `objective.py`:
    Defines the Optuna objective function used for hyperparameter optimization.
    Includes full model training, validation loop, and average accuracy computation.

- `eval_utils.py`:
    Utilities for computing test accuracy and confusion matrices from predicted outputs.

- `utils.py`:
    General helper functions for reproducibility, normalization, weight initialization,
    and hyperparameter combination generation.

How to Use
----------

This module is designed to support multiple dataset sources:
    - Real LFP data (`lfp_dataset.py`)
    - Synthetic datasets (`dataset_simulated_setting1.py`, `dataset_simulated_setting2.py`)

Start training and evaluation with:
    >>> python -m src.main


"""

# from .lfp_dataset import prepare_all_datasets
# from .dataset_simulated_setting1 import load_simulated_datasets
# from .dataset_simulated_setting2 import SyntheticMultimodalGraphDataset
# from .train import evaluate_best_model
# from .objective import objective
# from .utils import set_seed
