from itertools import combinations

import networkx as nx
from sklearn.metrics import f1_score
from typing import  Dict
from pgmpy.estimators import PC, HillClimbSearch, ExhaustiveSearch
from pgmpy.estimators import K2Score,BicScore,BDeuScore
from pgmpy.utils import get_example_model
from pgmpy.sampling import BayesianModelSampling
import numpy as np

###
from data_scores.factories import get_scorer
from argparse import ArgumentParser
from data_scores.data import  get_data
parser = ArgumentParser(description='DAG-GFlowNet for Strucure Learning.')
graph = parser.add_argument_group('Type of graph')
graph.add_argument('--graph', default='sachs', help='Type of graph')
graph.add_argument('--prior', type=str, default='uniform',choices=['uniform', 'erdos_renyi', 'edge', 'fair'])
graph.add_argument('--prior_kwargs', type=dict, default={},
                         help='Arguments of the prior over graphs.')
graph.add_argument('--scorer_kwargs', type=dict, default={},
                         help='Arguments of the scorer.')


args=parser.parse_args()
scorer,data,graph= get_scorer(args)
model=graph
####
graph = nx.to_numpy_array(graph)
graph = np.where(np.isnan(graph), 1, graph).astype('int32')
scorer(graph.flatten())
scoring_method = BDeuScore(data=data)
scoring_method.score(model)

