import os
import json
import pickle
import random
import time
import itertools

import numpy as np
from PIL import Image
import skimage.io as io
import matplotlib.pyplot as plt
from matplotlib.collections import PatchCollection
from matplotlib.patches import Polygon, Rectangle
from torch.utils.data import Dataset
import webdataset as wds

from minigpt4.minigpt4.datasets.datasets.base_dataset import BaseDataset
from minigpt4.minigpt4.datasets.datasets.caption_datasets import CaptionDataset


class UnnaturalDataset(Dataset):
    def __init__(self, text_processor, ann_path):
        """
        vis_root (string): Root directory of images (e.g. coco/images/)
        ann_root (string): directory to store the annotation file
        """
        self.text_processor = text_processor

        with open(ann_path, 'r') as f:
            self.ann = json.load(f)

    def __len__(self):
        return len(self.ann)

    def __getitem__(self, index):
        info = self.ann[index]["instances"][0]
        instruction = info["instruction_with_input"]
        constraints = info["constraints"]
        answer = info["output"]
        if constraints != None:
            instruction = instruction+" "+constraints

        return {
            "instruction_input": self.text_processor(instruction),
            "answer": self.text_processor(answer),
        }
