from android_world.agents.BoN.vllm_api import parallel_call_vllm
# from vllm_api import parallel_call_vllm
import time


import time
import ast  

def dynamic_memory(    
    goal: str,
    history: list[str],
    ui_elements: str,
    base64_image: str,
    additional_guidelines: list[str] | None = None,
) -> tuple[str, str]:
  """
  使用动态记忆机制生成用于行动选择的提示。
  该机制会总结较早的步骤，并将其与最近的步骤相结合。

  Args:
    goal: 当前目标。
    history: 代表完整操作历史的字符串列表。
    ui_elements: UI 元素的描述列表。
    base64_image: 当前屏幕的 Base64 编码字符串（在此逻辑中未使用，但为保持兼容性而保留）。
    additional_guidelines: 特定于任务的指南。

  Returns:
    一个元组，包含:
    - 将发送给 Agent 的行动选择文本提示。
    - 处理后的历史记录字符串 (摘要 + 近期步骤)。
  """
  
  # 如果历史记录为空或很短，则不需要复杂的记忆管理。
  if not history:
    processed_history = 'You just started, no action has been performed yet.'
  # 定义一个阈值，避免对过短的历史进行总结
  elif len(history) <= 5:
    processed_history = '\n'.join(history)
  else:

    filter_prompt = """**Current Goal**: {goal}

        **Full History** (as list):
        {history}

        **Task**: Return a filtered list of the SAME LENGTH where only the last N relevant steps are preserved (as-is) and all earlier steps are set to empty strings ''.

        **Example Input**: ['Step 1 - A', 'Step 2 - B', 'Step 3 - C', 'Step 4 - D']
        **Example Output**: ['', '', 'Step 3 - C', 'Step 4 - D']

        Return ONLY the Python list format, nothing else."""

    filter_sys_prompt = """You are a **Process Reward Model**. Your task is to evaluate a single **candidate action step** based on a **user's prompt** and **provided screen image**. To reduce the impact on the dialogue window, you need to dynamically manage the cache. Please dynamically manage the **user's action history** part, keeping only the necessary portions. Ensure that the essential key information is retained.""" + """**CRITICAL RULES**:
1. You MUST return a list of the EXACT SAME LENGTH as the input history
2. You MUST only keep the last N recent steps (where N is determined by relevance)
3. You MUST set all non-essential earlier steps to empty strings ''
4. You MUST NOT skip steps or create gaps - only preserve consecutive recent steps from the end
5. You MUST maintain the original step numbering and format

**Selection Criteria**:
- Preserve only the most recent steps necessary for current context
- Remove redundant or outdated information from the beginning
- Keep steps that provide essential operational context
- Consider both textual content and visual context from the screen image

**Output Format**: Return ONLY a Python list with the same length as input, where unwanted steps are empty strings."""

    filter_msg = [
        {'role': 'system', 'content': filter_sys_prompt},
        {'role': 'user', 'content': filter_prompt.format(goal=goal, history=str(history))}
    ]
    
    filter_msg_list = [filter_msg]
    model = "qwen2.5-vl-72b-instruct"
    temperature = 0.0
    max_tokens = 1000
    max_processes = 1

    print("Step 1/3: Filtering history to identify recent steps...")
    T1 = time.time()
    filtered_history_str = parallel_call_vllm(
        filter_msg_list, model=model, temperature=temperature, max_tokens=max_tokens,
        max_workers=max_processes, port="8005",                 
    )[0]
    T2 = time.time()
    print(f'-> Filtering took: {T2 - T1:.2f}s')

    try:
        # ast.literal_eval 是比 eval() 更安全的评估字符串字面量的方法
        filtered_history_list = ast.literal_eval(filtered_history_str)
        if not isinstance(filtered_history_list, list) or len(filtered_history_list) != len(history):
            raise ValueError("LLM output was not a list of the correct length.")
        
        # 根据过滤器的输出分离步骤
        steps_to_summarize = [
            original for original, filtered in zip(history, filtered_history_list) if filtered == ''
        ]
        recent_steps = [
            original for original, filtered in zip(history, filtered_history_list) if filtered != ''
        ]
        if not recent_steps and steps_to_summarize: # 处理 LLM 错误地将所有步骤都置为空字符串的情况
             raise ValueError("LLM returned all empty strings, which is not allowed.")

    except (ValueError, SyntaxError) as e:
        print(f"Warning: Could not parse LLM filter output ({e}). Using fallback: keeping last 2 steps.")
        n_recent = 2
        steps_to_summarize = history[:-n_recent]
        recent_steps = history[-n_recent:]

    # --- 第 2 步：如果存在旧步骤，则对其进行总结 ---
    summary = ""
    if steps_to_summarize:
        print("Step 2/3: Summarizing older steps...")
        summarize_prompt = """You are an expert summarizer. Your task is to read a list of previous user actions and create a concise, **one sentence** summary. The summary should capture the main accomplishments and the state reached before the final few steps.

**Actions to Summarize**:
{actions}

**Instructions**:
- Be concise and to the point.
- Write in a narrative style (e.g., "The user logged in and navigated to...").
- Do not use a list format or mention step numbers.
- The summary should provide context for the "Recent Actions" that will follow it.

**Output**:
Provide ONLY the summary sentence.
"""
        actions_str = "\n".join(f"- {step}" for step in steps_to_summarize)
        summarize_msg = [
            {'role': 'system', 'content': 'You are a helpful assistant that summarizes text.'},
            {'role': 'user', 'content': summarize_prompt.format(actions=actions_str)}
        ]
        summarize_msg_list = [summarize_msg]

        T3 = time.time()
        summary = parallel_call_vllm(
            summarize_msg_list, model=model, temperature=0.0, max_tokens=500,
            max_workers=max_processes, port="8005",                 
        )[0].strip()
        T4 = time.time()
        print(f'-> Summarization took: {T4 - T3:.2f}s')

    # --- 第 3 步：将摘要和近期步骤组合成最终的历史记录 ---
    print("Step 3/3: Combining summary and recent history.")
    final_history_parts = []
    if summary:
        final_history_parts.append(f"**Summary of Past Actions**:\n{summary}")
    
    if recent_steps:
        # 仅当存在摘要时才为近期步骤添加标题，以作区分
        header = "**Recent Actions**:\n" if summary else ""
        recent_steps_str = "\n".join(recent_steps)
        final_history_parts.append(f"{header}{recent_steps_str}")
        
    processed_history = "\n\n".join(final_history_parts)
    # breakpoint()

  extra_guidelines = ''
  if additional_guidelines:
    extra_guidelines = 'For The Current Task:\n' + '\n'.join(f'- {g}' for g in additional_guidelines)

  final_prompt = ACTION_SELECTION_PROMPT_TEMPLATE.format(
      goal=goal,
      history=processed_history,
      ui_elements=ui_elements if ui_elements else 'Not available',
      additional_guidelines=extra_guidelines,
  )
  
  return final_prompt, processed_history


if __name__ == '__main__':
  goal =""

  ui = ""

  history =[]


  img = ""
  final_prompt, processed_history = dynamic_memory(goal, history, ui, img)
