import numpy as np
import pandas as pd


def generate_data_3d(freq: float, number_of_datapoints: int = 60000, seed=47385123, give_pop="False") -> np.ndarray:
    """Generates data with 3 features with myopicity

    The data is generated by 2 different populations with fractions F1 = F and F2 = 1-F:
        P1:                                 P2:
        X1,X2 ~ N(0,1)                      X1,X2 ~ 0
        X3 ~ 0                              X3 ~ N(0,1)
    One can obtain a lens operator by considering U ~ diag(110), F; diag(001), 1-F

    Args:
        freq: float, Frequencie F for the populations
    """
    p1_number_of_datapoints = int(freq*number_of_datapoints)
    p2_number_of_datapoints = number_of_datapoints - p1_number_of_datapoints
    np.random.seed(seed)

    x1 = np.random.normal(size=p1_number_of_datapoints, scale=10000)
    x2 = np.random.normal(size=p1_number_of_datapoints, scale=34)
    x3 = np.repeat(0, p1_number_of_datapoints)
    p1_data = pd.DataFrame({'x1': x1, 'x2': x2, 'x3': x3})

    x1 = np.repeat(0, p2_number_of_datapoints)
    x2 = np.repeat(0, p2_number_of_datapoints)
    x3 = np.random.normal(size=p2_number_of_datapoints, scale=100)
    p2_data = pd.DataFrame({'x1': x1, 'x2': x2, 'x3': x3})

    x_data = p1_data._append(p2_data).to_numpy()

    if give_pop == True:
        return p1_data.to_numpy(), p2_data.to_numpy()

    return x_data
