BEHAVIOR_RULES = {
    'network_communication': lambda n: n.startswith(('socket.', 'requests.', 'urllib.', 'httpx.', 'aiohttp.', 'ftplib.')),
    'network_data_reception': lambda n: n.endswith(('.recv', '.recvfrom')),
    'dns_activity':        lambda n: n in ('socket.gethostbyname', 'socket.getaddrinfo', 'dns.resolver.query'),
    'data_exfil_http':     lambda n: n in ('requests.post', 'urllib.request.urlopen', 'httpx.post', 'aiohttp.ClientSession.post'),
    'data_exfil_socket':   lambda n: n.endswith(('.send', '.sendto', '.sendall')),
    'data_exfil_scp':      lambda n: n.endswith(('.SCPClient.get', '.get')),
    'data_exfil_webhook':  lambda n: n.endswith(('.Webhook.send', '.WebhookClient.send')), 
    'data_collection_stdin': lambda n: n == 'sys.stdin.read',
    'lateral_movement_ssh': lambda n: n.startswith('paramiko.'),
    'self_propagation_scp': lambda n: n.endswith(('.SCPClient.put', '.put')),
    'fs_read':             lambda n: n in ('open', 'pathlib.Path.read_text', 'pathlib.Path.read_bytes', 'json.load', 'pickle.load', 'yaml.load'),
    'fs_write':            lambda n: n in ('open', 'pathlib.Path.write_text', 'pathlib.Path.write_bytes', 'json.dump', 'pickle.dump', 'yaml.dump', 'shutil.copy', 'shutil.move'),
    'payload_dumping':     lambda n: n in ('open', 'pathlib.Path.write_bytes'),
    'fs_enum':             lambda n: n in ('os.listdir', 'os.scandir', 'glob.glob', 'os.walk'),
    'credential_access_bruteforce': lambda n: n.endswith('.SSHClient.connect'),
    'credential_access':   lambda n: any(sub in n for sub in (
                               'getpass.getuser', 'os.environ.get', 'keyring.get_password', 
                               'sqlite3.connect', 
                               '.ssh', '/.aws/credentials', '/.gcp/credentials.json' 
                           )),
    'command_execution':   lambda n: n in ('subprocess.Popen', 'subprocess.run', 'subprocess.call', 'os.system', 'os.popen', 'pty.spawn') or n.startswith('os.exec'),
    'dynamic_code_exec':   lambda n: n in ('eval', 'exec', 'compile'),
    'dynamic_code_load':   lambda n: n in ('importlib.import_module', 'importlib.util.spec_from_file_location', '__import__'),
    'reflection_abuse':    lambda n: n in ('getattr', 'setattr'), 
    'crypto_activity':     lambda n: n.startswith(('hashlib.', 'Crypto.', 'cryptography.')) or n == 'base64.b64encode',
    'deobfuscation':       lambda n: n.startswith(('base64.b64decode', 'base64.b85decode', 'codecs.decode', 'binascii.unhexlify')),
    'obfuscation_dynamic_config': lambda n: n in ('math.sqrt',),
    'system_recon':        lambda n: n in ('os.uname', 'platform.platform', 'platform.machine', 'os.getlogin', 'socket.gethostname', 'sys.platform', 'psutil.virtual_memory'),
    'process_recon':       lambda n: n in ('os.getpid', 'psutil.pids', 'psutil.process_iter'),
    'permission_manipulation': lambda n: n == 'os.chmod',
    'defense_evasion_daemon': lambda n: n.startswith('daemon.DaemonContext'),
    'defense_evasion':     lambda n: n in ('ctypes.windll.user32.BlockInput', 'os.remove'),
    'defense_evasion_gui': lambda n: n.endswith('.ignore') and 'Event' in n,
    'persistence_registry': lambda n: n.startswith('winreg.'), 
    'persistence_cron':     lambda n: n.startswith('crontab.'), 
    'keylogging':          lambda n: n.startswith(('pynput.keyboard', 'pyxhook.')),
    'user_input_prompt':   lambda n: n == 'builtins.input' or n == 'input',
    'clipboard_abuse':     lambda n: n.startswith('pyperclip.'),
    'screenshot':          lambda n: n in ('PIL.ImageGrab.grab', 'mss.mss'),
    'gui_abuse':           lambda n: any(sub in n for sub in ('.QApplication', '.QDialog', '.show', '.move')),
    'install_hook':        lambda n: n in ('setup', 'setuptools.setup')
}
KNOWN_LIBS = [
    'requests',    'urllib3',    'httpx',    'aiohttp',    'flask',    'django',    'fastapi',    'starlette',
    'tornado',    'pyramid',    'beautifulsoup4',    'scrapy',    'selenium',    'websockets',    'graphene',
    'numpy',    'pandas',    'scipy',    'scikit-learn',    'matplotlib',    'seaborn',    'plotly',    'statsmodels',
    'torch',    'tensorflow',    'keras',    'jax',    'xgboost',    'lightgbm',    'transformers',    'nltk',    'spacy',
    'gensim',    'pillow',    'opencv-python',
    'boto3',    'awscli',    'google-api-python-client',    'google-cloud-storage',    'azure-identity',    'azure-storage-blob',
    'docker',    'kubernetes',    'ansible',    'pulumi',    'paramiko',
    'sqlalchemy',    'peewee',    'psycopg2-binary',    'mysql-connector-python',    'redis',    'pymongo',    'asyncpg',
    'pydantic',    'pyyaml',    'python-dotenv',    'loguru',    'tqdm',    'click',    'typer',    'rich',    'asyncio',   'python-daemon'
    'cryptography',    'pyjwt',    'keyring',
    'PySide2',    'PyQt5',    'tkinter',    'kivy',
    'pyxhook',     'pynput',    'scp',
    ]
BUILTIN_DECOS = {
    'property',    'staticmethod',    'classmethod',
    'lru_cache',    'cached_property',    'total_ordering',    'wraps',    'singledispatch',    'singledispatchmethod',    'cache', 
    'abstractmethod',    'abstractproperty',
    'dataclass',
    'final',    'override',     'overload',
    'coroutine',
    'setter',    'deleter',
}